/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.client.android.result;

import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.Intent;
import android.util.Log;
import barcodescanner.xservices.nl.barcodescanner.R;
import com.google.zxing.client.android.result.ResultHandler;
import com.google.zxing.client.result.CalendarParsedResult;
import com.google.zxing.client.result.ParsedResult;
import java.text.DateFormat;
import java.util.Date;

public final class CalendarResultHandler
extends ResultHandler {
    private static final String TAG = CalendarResultHandler.class.getSimpleName();
    private static final int[] buttons = new int[]{R.string.button_add_calendar};

    public CalendarResultHandler(Activity activity, ParsedResult result) {
        super(activity, result);
    }

    @Override
    public int getButtonCount() {
        return buttons.length;
    }

    @Override
    public int getButtonText(int index) {
        return buttons[index];
    }

    @Override
    public void handleButtonPress(int index) {
        if (index == 0) {
            CalendarParsedResult calendarResult = (CalendarParsedResult)this.getResult();
            String description = calendarResult.getDescription();
            String organizer = calendarResult.getOrganizer();
            if (organizer != null) {
                description = description == null ? organizer : description + '\n' + organizer;
            }
            this.addCalendarEvent(calendarResult.getSummary(), calendarResult.getStart(), calendarResult.isStartAllDay(), calendarResult.getEnd(), calendarResult.getLocation(), description, calendarResult.getAttendees());
        }
    }

    private void addCalendarEvent(String summary, Date start, boolean allDay, Date end, String location, String description, String[] attendees) {
        Intent intent = new Intent("android.intent.action.INSERT");
        intent.setType("vnd.android.cursor.item/event");
        long startMilliseconds = start.getTime();
        intent.putExtra("beginTime", startMilliseconds);
        if (allDay) {
            intent.putExtra("allDay", true);
        }
        long endMilliseconds = end == null ? (allDay ? startMilliseconds + 86400000L : startMilliseconds) : end.getTime();
        intent.putExtra("endTime", endMilliseconds);
        intent.putExtra("title", summary);
        intent.putExtra("eventLocation", location);
        intent.putExtra("description", description);
        if (attendees != null) {
            intent.putExtra("android.intent.extra.EMAIL", attendees);
        }
        try {
            this.rawLaunchIntent(intent);
        }
        catch (ActivityNotFoundException anfe) {
            Log.w((String)TAG, (String)"No calendar app available that responds to android.intent.action.INSERT");
            intent.setAction("android.intent.action.EDIT");
            this.launchIntent(intent);
        }
    }

    @Override
    public CharSequence getDisplayContents() {
        CalendarParsedResult calResult = (CalendarParsedResult)this.getResult();
        StringBuilder result = new StringBuilder(100);
        ParsedResult.maybeAppend(calResult.getSummary(), result);
        Date start = calResult.getStart();
        ParsedResult.maybeAppend(CalendarResultHandler.format(calResult.isStartAllDay(), start), result);
        Date end = calResult.getEnd();
        if (end != null) {
            if (calResult.isEndAllDay() && !start.equals(end)) {
                end = new Date(end.getTime() - 86400000L);
            }
            ParsedResult.maybeAppend(CalendarResultHandler.format(calResult.isEndAllDay(), end), result);
        }
        ParsedResult.maybeAppend(calResult.getLocation(), result);
        ParsedResult.maybeAppend(calResult.getOrganizer(), result);
        ParsedResult.maybeAppend(calResult.getAttendees(), result);
        ParsedResult.maybeAppend(calResult.getDescription(), result);
        return result.toString();
    }

    private static String format(boolean allDay, Date date) {
        if (date == null) {
            return null;
        }
        DateFormat format = allDay ? DateFormat.getDateInstance(2) : DateFormat.getDateTimeInstance(2, 2);
        return format.format(date);
    }

    @Override
    public int getDisplayTitle() {
        return R.string.result_calendar;
    }
}

