/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.client.android.result;

import android.app.Activity;
import barcodescanner.xservices.nl.barcodescanner.R;
import com.google.zxing.client.android.LocaleManager;
import com.google.zxing.client.android.result.ResultHandler;
import com.google.zxing.client.result.ParsedResult;
import com.google.zxing.client.result.URIParsedResult;
import java.util.Locale;

public final class URIResultHandler
extends ResultHandler {
    private static final String[] SECURE_PROTOCOLS = new String[]{"otpauth:"};
    private static final int[] buttons = new int[]{R.string.button_open_browser, R.string.button_share_by_email, R.string.button_share_by_sms, R.string.button_search_book_contents};

    public URIResultHandler(Activity activity, ParsedResult result) {
        super(activity, result);
    }

    @Override
    public int getButtonCount() {
        if (LocaleManager.isBookSearchUrl(((URIParsedResult)this.getResult()).getURI())) {
            return buttons.length;
        }
        return buttons.length - 1;
    }

    @Override
    public int getButtonText(int index) {
        return buttons[index];
    }

    @Override
    public Integer getDefaultButtonID() {
        return 0;
    }

    @Override
    public void handleButtonPress(int index) {
        URIParsedResult uriResult = (URIParsedResult)this.getResult();
        String uri = uriResult.getURI();
        switch (index) {
            case 0: {
                this.openURL(uri);
                break;
            }
            case 1: {
                this.shareByEmail(uri);
                break;
            }
            case 2: {
                this.shareBySMS(uri);
                break;
            }
            case 3: {
                this.searchBookContents(uri);
            }
        }
    }

    @Override
    public int getDisplayTitle() {
        return R.string.result_uri;
    }

    @Override
    public boolean areContentsSecure() {
        URIParsedResult uriResult = (URIParsedResult)this.getResult();
        String uri = uriResult.getURI().toLowerCase(Locale.ENGLISH);
        for (String secure : SECURE_PROTOCOLS) {
            if (!uri.startsWith(secure)) continue;
            return true;
        }
        return false;
    }
}

