/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.client.android;

import android.app.Activity;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.res.AssetFileDescriptor;
import android.media.AudioManager;
import android.media.MediaPlayer;
import android.os.Vibrator;
import android.preference.PreferenceManager;
import android.util.Log;
import barcodescanner.xservices.nl.barcodescanner.R;
import java.io.Closeable;
import java.io.IOException;

final class BeepManager
implements MediaPlayer.OnErrorListener,
Closeable {
    private static final String TAG = BeepManager.class.getSimpleName();
    private static final float BEEP_VOLUME = 0.1f;
    private static final long VIBRATE_DURATION = 200L;
    private final Activity activity;
    private MediaPlayer mediaPlayer;
    private boolean playBeep;
    private boolean vibrate;

    BeepManager(Activity activity) {
        this.activity = activity;
        this.mediaPlayer = null;
        this.updatePrefs();
    }

    synchronized void updatePrefs() {
        SharedPreferences prefs = PreferenceManager.getDefaultSharedPreferences((Context)this.activity);
        this.playBeep = BeepManager.shouldBeep(prefs, (Context)this.activity);
        this.vibrate = prefs.getBoolean("preferences_vibrate", false);
        if (this.playBeep && this.mediaPlayer == null) {
            this.activity.setVolumeControlStream(3);
            this.mediaPlayer = this.buildMediaPlayer((Context)this.activity);
        }
    }

    synchronized void playBeepSoundAndVibrate() {
        if (this.playBeep && this.mediaPlayer != null) {
            this.mediaPlayer.start();
        }
        if (this.vibrate) {
            Vibrator vibrator = (Vibrator)this.activity.getSystemService("vibrator");
            vibrator.vibrate(200L);
        }
    }

    private static boolean shouldBeep(SharedPreferences prefs, Context activity) {
        AudioManager audioService;
        boolean shouldPlayBeep = prefs.getBoolean("preferences_play_beep", true);
        if (shouldPlayBeep && (audioService = (AudioManager)activity.getSystemService("audio")).getRingerMode() != 2) {
            shouldPlayBeep = false;
        }
        return shouldPlayBeep;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MediaPlayer buildMediaPlayer(Context activity) {
        MediaPlayer mediaPlayer = new MediaPlayer();
        try {
            try (AssetFileDescriptor file = activity.getResources().openRawResourceFd(R.raw.beep);){
                mediaPlayer.setDataSource(file.getFileDescriptor(), file.getStartOffset(), file.getLength());
            }
            mediaPlayer.setOnErrorListener((MediaPlayer.OnErrorListener)this);
            mediaPlayer.setAudioStreamType(3);
            mediaPlayer.setLooping(false);
            mediaPlayer.setVolume(0.1f, 0.1f);
            mediaPlayer.prepare();
            return mediaPlayer;
        }
        catch (IOException ioe) {
            Log.w((String)TAG, (Throwable)ioe);
            mediaPlayer.release();
            return null;
        }
    }

    public synchronized boolean onError(MediaPlayer mp, int what, int extra) {
        if (what == 100) {
            this.activity.finish();
        } else {
            this.close();
            this.updatePrefs();
        }
        return true;
    }

    @Override
    public synchronized void close() {
        if (this.mediaPlayer != null) {
            this.mediaPlayer.release();
            this.mediaPlayer = null;
        }
    }
}

