/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.client.android;

import android.app.AlertDialog;
import android.content.Context;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.preference.CheckBoxPreference;
import android.preference.EditTextPreference;
import android.preference.Preference;
import android.preference.PreferenceFragment;
import android.preference.PreferenceScreen;
import barcodescanner.xservices.nl.barcodescanner.R;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;

public final class PreferencesFragment
extends PreferenceFragment
implements SharedPreferences.OnSharedPreferenceChangeListener {
    private CheckBoxPreference[] checkBoxPrefs;

    public void onCreate(Bundle icicle) {
        super.onCreate(icicle);
        this.addPreferencesFromResource(R.xml.preferences);
        PreferenceScreen preferences = this.getPreferenceScreen();
        preferences.getSharedPreferences().registerOnSharedPreferenceChangeListener((SharedPreferences.OnSharedPreferenceChangeListener)this);
        this.checkBoxPrefs = PreferencesFragment.findDecodePrefs(preferences, "preferences_decode_1D_product", "preferences_decode_1D_industrial", "preferences_decode_QR", "preferences_decode_Data_Matrix", "preferences_decode_Aztec", "preferences_decode_PDF417");
        this.disableLastCheckedPref();
        EditTextPreference customProductSearch = (EditTextPreference)preferences.findPreference((CharSequence)"preferences_custom_product_search");
        customProductSearch.setOnPreferenceChangeListener((Preference.OnPreferenceChangeListener)new CustomSearchURLValidator());
    }

    private static CheckBoxPreference[] findDecodePrefs(PreferenceScreen preferences, String ... keys) {
        CheckBoxPreference[] prefs = new CheckBoxPreference[keys.length];
        for (int i = 0; i < keys.length; ++i) {
            prefs[i] = (CheckBoxPreference)preferences.findPreference((CharSequence)keys[i]);
        }
        return prefs;
    }

    public void onSharedPreferenceChanged(SharedPreferences sharedPreferences, String key) {
        this.disableLastCheckedPref();
    }

    private void disableLastCheckedPref() {
        ArrayList<CheckBoxPreference> checked = new ArrayList<CheckBoxPreference>(this.checkBoxPrefs.length);
        for (CheckBoxPreference pref : this.checkBoxPrefs) {
            if (!pref.isChecked()) continue;
            checked.add(pref);
        }
        boolean disable = checked.size() <= 1;
        for (CheckBoxPreference pref : this.checkBoxPrefs) {
            pref.setEnabled(!disable || !checked.contains(pref));
        }
    }

    private class CustomSearchURLValidator
    implements Preference.OnPreferenceChangeListener {
        private CustomSearchURLValidator() {
        }

        public boolean onPreferenceChange(Preference preference, Object newValue) {
            if (!this.isValid(newValue)) {
                AlertDialog.Builder builder = new AlertDialog.Builder((Context)PreferencesFragment.this.getActivity());
                builder.setTitle(R.string.msg_error);
                builder.setMessage(R.string.msg_invalid_value);
                builder.setCancelable(true);
                builder.show();
                return false;
            }
            return true;
        }

        private boolean isValid(Object newValue) {
            if (newValue == null) {
                return true;
            }
            String valueString = newValue.toString();
            if (valueString.isEmpty()) {
                return true;
            }
            valueString = valueString.replaceAll("%[st]", "");
            valueString = valueString.replaceAll("%f(?![0-9a-f])", "");
            try {
                URI uri = new URI(valueString);
                return uri.getScheme() != null;
            }
            catch (URISyntaxException use) {
                return false;
            }
        }
    }
}

