/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.client.android.result;

import android.app.Activity;
import android.telephony.PhoneNumberUtils;
import android.text.SpannableString;
import android.text.style.StyleSpan;
import barcodescanner.xservices.nl.barcodescanner.R;
import com.google.zxing.client.android.result.ResultHandler;
import com.google.zxing.client.result.AddressBookParsedResult;
import com.google.zxing.client.result.ParsedResult;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public final class AddressBookResultHandler
extends ResultHandler {
    private static final DateFormat[] DATE_FORMATS;
    private static final int[] BUTTON_TEXTS;
    private final boolean[] fields;
    private int buttonCount;

    private int mapIndexToAction(int index) {
        if (index < this.buttonCount) {
            int count = -1;
            for (int x = 0; x < 4; ++x) {
                if (this.fields[x]) {
                    ++count;
                }
                if (count != index) continue;
                return x;
            }
        }
        return -1;
    }

    public AddressBookResultHandler(Activity activity, ParsedResult result) {
        super(activity, result);
        AddressBookParsedResult addressResult = (AddressBookParsedResult)result;
        String[] addresses = addressResult.getAddresses();
        String[] phoneNumbers = addressResult.getPhoneNumbers();
        String[] emails = addressResult.getEmails();
        this.fields = new boolean[4];
        this.fields[0] = true;
        this.fields[1] = addresses != null && addresses.length > 0 && addresses[0] != null && !addresses[0].isEmpty();
        this.fields[2] = phoneNumbers != null && phoneNumbers.length > 0;
        this.fields[3] = emails != null && emails.length > 0;
        this.buttonCount = 0;
        for (int x = 0; x < 4; ++x) {
            if (!this.fields[x]) continue;
            ++this.buttonCount;
        }
    }

    @Override
    public int getButtonCount() {
        return this.buttonCount;
    }

    @Override
    public int getButtonText(int index) {
        return BUTTON_TEXTS[this.mapIndexToAction(index)];
    }

    @Override
    public void handleButtonPress(int index) {
        AddressBookParsedResult addressResult = (AddressBookParsedResult)this.getResult();
        String[] addresses = addressResult.getAddresses();
        String address1 = addresses == null || addresses.length < 1 ? null : addresses[0];
        String[] addressTypes = addressResult.getAddressTypes();
        String address1Type = addressTypes == null || addressTypes.length < 1 ? null : addressTypes[0];
        int action = this.mapIndexToAction(index);
        switch (action) {
            case 0: {
                this.addContact(addressResult.getNames(), addressResult.getNicknames(), addressResult.getPronunciation(), addressResult.getPhoneNumbers(), addressResult.getPhoneTypes(), addressResult.getEmails(), addressResult.getEmailTypes(), addressResult.getNote(), addressResult.getInstantMessenger(), address1, address1Type, addressResult.getOrg(), addressResult.getTitle(), addressResult.getURLs(), addressResult.getBirthday(), addressResult.getGeo());
                break;
            }
            case 1: {
                this.searchMap(address1);
                break;
            }
            case 2: {
                this.dialPhone(addressResult.getPhoneNumbers()[0]);
                break;
            }
            case 3: {
                this.sendEmail(addressResult.getEmails(), null, null, null, null);
                break;
            }
        }
    }

    private static Date parseDate(String s) {
        for (DateFormat currentFormat : DATE_FORMATS) {
            try {
                return currentFormat.parse(s);
            }
            catch (ParseException parseException) {
            }
        }
        return null;
    }

    @Override
    public CharSequence getDisplayContents() {
        Date date;
        AddressBookParsedResult result = (AddressBookParsedResult)this.getResult();
        StringBuilder contents = new StringBuilder(100);
        ParsedResult.maybeAppend(result.getNames(), contents);
        int namesLength = contents.length();
        String pronunciation = result.getPronunciation();
        if (pronunciation != null && !pronunciation.isEmpty()) {
            contents.append("\n(");
            contents.append(pronunciation);
            contents.append(')');
        }
        ParsedResult.maybeAppend(result.getTitle(), contents);
        ParsedResult.maybeAppend(result.getOrg(), contents);
        ParsedResult.maybeAppend(result.getAddresses(), contents);
        String[] numbers = result.getPhoneNumbers();
        if (numbers != null) {
            for (String number : numbers) {
                if (number == null) continue;
                ParsedResult.maybeAppend(PhoneNumberUtils.formatNumber((String)number), contents);
            }
        }
        ParsedResult.maybeAppend(result.getEmails(), contents);
        ParsedResult.maybeAppend(result.getURLs(), contents);
        String birthday = result.getBirthday();
        if (birthday != null && !birthday.isEmpty() && (date = AddressBookResultHandler.parseDate(birthday)) != null) {
            ParsedResult.maybeAppend(DateFormat.getDateInstance(2).format(date.getTime()), contents);
        }
        ParsedResult.maybeAppend(result.getNote(), contents);
        if (namesLength > 0) {
            SpannableString styled = new SpannableString((CharSequence)contents.toString());
            styled.setSpan((Object)new StyleSpan(1), 0, namesLength, 0);
            return styled;
        }
        return contents.toString();
    }

    @Override
    public int getDisplayTitle() {
        return R.string.result_address_book;
    }

    static {
        for (DateFormat format : DATE_FORMATS = new DateFormat[]{new SimpleDateFormat("yyyyMMdd", Locale.ENGLISH), new SimpleDateFormat("yyyyMMdd'T'HHmmss", Locale.ENGLISH), new SimpleDateFormat("yyyy-MM-dd", Locale.ENGLISH), new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss", Locale.ENGLISH)}) {
            format.setLenient(false);
        }
        BUTTON_TEXTS = new int[]{R.string.button_add_contact, R.string.button_show_map, R.string.button_dial, R.string.button_email};
    }
}

