/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.client.android.result;

import android.app.Activity;
import android.telephony.PhoneNumberUtils;
import barcodescanner.xservices.nl.barcodescanner.R;
import com.google.zxing.client.android.result.ResultHandler;
import com.google.zxing.client.result.ParsedResult;
import com.google.zxing.client.result.SMSParsedResult;

public final class SMSResultHandler
extends ResultHandler {
    private static final int[] buttons = new int[]{R.string.button_sms, R.string.button_mms};

    public SMSResultHandler(Activity activity, ParsedResult result) {
        super(activity, result);
    }

    @Override
    public int getButtonCount() {
        return buttons.length;
    }

    @Override
    public int getButtonText(int index) {
        return buttons[index];
    }

    @Override
    public void handleButtonPress(int index) {
        SMSParsedResult smsResult = (SMSParsedResult)this.getResult();
        String number = smsResult.getNumbers()[0];
        switch (index) {
            case 0: {
                this.sendSMS(number, smsResult.getBody());
                break;
            }
            case 1: {
                this.sendMMS(number, smsResult.getSubject(), smsResult.getBody());
            }
        }
    }

    @Override
    public CharSequence getDisplayContents() {
        SMSParsedResult smsResult = (SMSParsedResult)this.getResult();
        String[] rawNumbers = smsResult.getNumbers();
        String[] formattedNumbers = new String[rawNumbers.length];
        for (int i = 0; i < rawNumbers.length; ++i) {
            formattedNumbers[i] = PhoneNumberUtils.formatNumber((String)rawNumbers[i]);
        }
        StringBuilder contents = new StringBuilder(50);
        ParsedResult.maybeAppend(formattedNumbers, contents);
        ParsedResult.maybeAppend(smsResult.getSubject(), contents);
        ParsedResult.maybeAppend(smsResult.getBody(), contents);
        return contents.toString();
    }

    @Override
    public int getDisplayTitle() {
        return R.string.result_sms;
    }
}

