(window["webpackJsonp"] = window["webpackJsonp"] || []).push([["bluetooth-bluetooth-module"],{

/***/ "./src/app/bluetooth/bluetooth.module.ts":
/*!***********************************************!*\
  !*** ./src/app/bluetooth/bluetooth.module.ts ***!
  \***********************************************/
/*! exports provided: BluetoothPageModule */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "BluetoothPageModule", function() { return BluetoothPageModule; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ "./node_modules/@angular/core/fesm5/core.js");
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/common */ "./node_modules/@angular/common/fesm5/common.js");
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/forms */ "./node_modules/@angular/forms/fesm5/forms.js");
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @angular/router */ "./node_modules/@angular/router/fesm5/router.js");
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @ionic/angular */ "./node_modules/@ionic/angular/dist/fesm5.js");
/* harmony import */ var _bluetooth_page__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./bluetooth.page */ "./src/app/bluetooth/bluetooth.page.ts");







var routes = [
    {
        path: '',
        component: _bluetooth_page__WEBPACK_IMPORTED_MODULE_6__["BluetoothPage"]
    }
];
var BluetoothPageModule = /** @class */ (function () {
    function BluetoothPageModule() {
    }
    BluetoothPageModule = tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"]([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["NgModule"])({
            imports: [
                _angular_common__WEBPACK_IMPORTED_MODULE_2__["CommonModule"],
                _angular_forms__WEBPACK_IMPORTED_MODULE_3__["FormsModule"],
                _ionic_angular__WEBPACK_IMPORTED_MODULE_5__["IonicModule"],
                _angular_router__WEBPACK_IMPORTED_MODULE_4__["RouterModule"].forChild(routes)
            ],
            declarations: [_bluetooth_page__WEBPACK_IMPORTED_MODULE_6__["BluetoothPage"]]
        })
    ], BluetoothPageModule);
    return BluetoothPageModule;
}());



/***/ }),

/***/ "./src/app/bluetooth/bluetooth.page.html":
/*!***********************************************!*\
  !*** ./src/app/bluetooth/bluetooth.page.html ***!
  \***********************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = "<ion-header>\n  <ion-toolbar>\n    <ion-buttons slot=\"start\">\n      <ion-menu-button></ion-menu-button>\n    </ion-buttons>\n\n    <ion-title>蓝牙</ion-title>\n\n  </ion-toolbar>\n</ion-header>\n\n<ion-content>\n  <ion-list #scheduleList>\n    <ion-item-group>\n      <ion-item>\n        <ion-label>\n          蓝牙\n        </ion-label>\n        <ion-toggle [(ngModel)]='blueStatus' (ionChange)='changeBlueStatus()'></ion-toggle>\n      </ion-item>\n      <ion-item-divider sticky>\n        <ion-label>\n          搜索到的设备\n        </ion-label>\n      </ion-item-divider>\n      <ion-item-sliding *ngFor=\"let device of unpairedDevices\">\n        <ion-item button>\n          <ion-label>\n            <h3>{{device.name}} {{device.id}}</h3>\n          </ion-label>\n          <ion-note slot=\"end\">\n            <ion-spinner icon=\"spiral\"></ion-spinner>\n          </ion-note>\n        </ion-item>\n      </ion-item-sliding>\n    </ion-item-group>\n  </ion-list>\n</ion-content>"

/***/ }),

/***/ "./src/app/bluetooth/bluetooth.page.scss":
/*!***********************************************!*\
  !*** ./src/app/bluetooth/bluetooth.page.scss ***!
  \***********************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = "ion-item-sliding[track='ionic'] ion-label {\n  border-left: 2px solid var(--ion-color-primary);\n  padding-left: 10px; }\n\nion-item-sliding[track='angular'] ion-label {\n  border-left: 2px solid #ac282b;\n  padding-left: 10px; }\n\nion-item-sliding[track='communication'] ion-label {\n  border-left: 2px solid #8e8d93;\n  padding-left: 10px; }\n\nion-item-sliding[track='tooling'] ion-label {\n  border-left: 2px solid #fe4c52;\n  padding-left: 10px; }\n\nion-item-sliding[track='services'] ion-label {\n  border-left: 2px solid #fd8b2d;\n  padding-left: 10px; }\n\nion-item-sliding[track='design'] ion-label {\n  border-left: 2px solid #fed035;\n  padding-left: 10px; }\n\nion-item-sliding[track='workshop'] ion-label {\n  border-left: 2px solid #69bb7b;\n  padding-left: 10px; }\n\nion-item-sliding[track='food'] ion-label {\n  border-left: 2px solid #3bc7c4;\n  padding-left: 10px; }\n\nion-item-sliding[track='documentation'] ion-label {\n  border-left: 2px solid #b16be3;\n  padding-left: 10px; }\n\nion-item-sliding[track='navigation'] ion-label {\n  border-left: 2px solid #6600cc;\n  padding-left: 10px; }\n\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbInNyYy9hcHAvYmx1ZXRvb3RoL0Q6XFxteUNvZGVcXHNnQXBwL3NyY1xcYXBwXFxibHVldG9vdGhcXGJsdWV0b290aC5wYWdlLnNjc3MiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBY0U7RUFDRSwrQ0FkNkI7RUFlN0Isa0JBQWtCLEVBQUE7O0FBRnBCO0VBQ0UsOEJBYmM7RUFjZCxrQkFBa0IsRUFBQTs7QUFGcEI7RUFDRSw4QkFab0I7RUFhcEIsa0JBQWtCLEVBQUE7O0FBRnBCO0VBQ0UsOEJBWGM7RUFZZCxrQkFBa0IsRUFBQTs7QUFGcEI7RUFDRSw4QkFWZTtFQVdmLGtCQUFrQixFQUFBOztBQUZwQjtFQUNFLDhCQVRhO0VBVWIsa0JBQWtCLEVBQUE7O0FBRnBCO0VBQ0UsOEJBUmU7RUFTZixrQkFBa0IsRUFBQTs7QUFGcEI7RUFDRSw4QkFQVztFQVFYLGtCQUFrQixFQUFBOztBQUZwQjtFQUNFLDhCQU5vQjtFQU9wQixrQkFBa0IsRUFBQTs7QUFGcEI7RUFDRSw4QkFMaUI7RUFNakIsa0JBQWtCLEVBQUEiLCJmaWxlIjoic3JjL2FwcC9ibHVldG9vdGgvYmx1ZXRvb3RoLnBhZ2Uuc2NzcyIsInNvdXJjZXNDb250ZW50IjpbIiRjYXRlZ29yaWVzOiAoXHJcbiAgaW9uaWM6IHZhcigtLWlvbi1jb2xvci1wcmltYXJ5KSxcclxuICBhbmd1bGFyOiAjYWMyODJiLFxyXG4gIGNvbW11bmljYXRpb246ICM4ZThkOTMsXHJcbiAgdG9vbGluZzogI2ZlNGM1MixcclxuICBzZXJ2aWNlczogI2ZkOGIyZCxcclxuICBkZXNpZ246ICNmZWQwMzUsXHJcbiAgd29ya3Nob3A6ICM2OWJiN2IsXHJcbiAgZm9vZDogIzNiYzdjNCxcclxuICBkb2N1bWVudGF0aW9uOiAjYjE2YmUzLFxyXG4gIG5hdmlnYXRpb246ICM2NjAwY2NcclxuKTtcclxuXHJcbkBlYWNoICR0cmFjaywgJHZhbHVlIGluIG1hcC1yZW1vdmUoJGNhdGVnb3JpZXMpIHtcclxuICBpb24taXRlbS1zbGlkaW5nW3RyYWNrPScjeyR0cmFja30nXSBpb24tbGFiZWwge1xyXG4gICAgYm9yZGVyLWxlZnQ6IDJweCBzb2xpZCAkdmFsdWU7XHJcbiAgICBwYWRkaW5nLWxlZnQ6IDEwcHg7XHJcbiAgfVxyXG59XHJcbiJdfQ== */"

/***/ }),

/***/ "./src/app/bluetooth/bluetooth.page.ts":
/*!*********************************************!*\
  !*** ./src/app/bluetooth/bluetooth.page.ts ***!
  \*********************************************/
/*! exports provided: BluetoothPage */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "BluetoothPage", function() { return BluetoothPage; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ "./node_modules/@angular/core/fesm5/core.js");
/* harmony import */ var _ionic_native_bluetooth_serial_ngx__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @ionic-native/bluetooth-serial/ngx */ "./node_modules/@ionic-native/bluetooth-serial/ngx/index.js");
/* harmony import */ var _ionic_native_bluetooth_le_ngx__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @ionic-native/bluetooth-le/ngx */ "./node_modules/@ionic-native/bluetooth-le/ngx/index.js");
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @ionic/angular */ "./node_modules/@ionic/angular/dist/fesm5.js");





var BluetoothPage = /** @class */ (function () {
    function BluetoothPage(bluetoothSerial, alertCtrl, bluetoothle, plt) {
        this.bluetoothSerial = bluetoothSerial;
        this.alertCtrl = alertCtrl;
        this.bluetoothle = bluetoothle;
        this.plt = plt;
        // unpairedDevices: any;
        this.unpairedDevices = [
            {
                "address": "56:4E:D7:E2:EC:82",
                "id": "56:4E:D7:E2:EC:82",
                "class": 7936
            },
            {
                "name": "DL-886BW-83CE",
                "address": "C0:15:83:FD:83:CE",
                "id": "C0:15:83:FD:83:CE",
                "class": 7936
            },
            {
                "address": "75:73:40:AF:3F:10",
                "id": "75:73:40:AF:3F:10",
                "class": 7936
            },
            {
                "name": "小米手机",
                "address": "D8:CE:3A:70:2E:C8",
                "id": "D8:CE:3A:70:2E:C8",
                "class": 524
            },
            {
                "name": "DL-886BW-83CE",
                "address": "00:15:83:FD:83:CE",
                "id": "00:15:83:FD:83:CE",
                "class": 1664
            },
            {
                "name": "OPPO Reno",
                "address": "4C:6F:9C:9F:7C:24",
                "id": "4C:6F:9C:9F:7C:24",
                "class": 524
            },
            {
                "address": "7B:79:82:37:BB:FF",
                "id": "7B:79:82:37:BB:FF",
                "class": 7936
            },
            {
                "name": "mb_xxmvSDrU",
                "address": "D4:3A:48:AF:19:C7",
                "id": "D4:3A:48:AF:19:C7",
                "class": 7936
            }
        ];
        this.blueStatus = false;
        this.success = function (data) { return alert(data); };
        this.fail = function (error) { return alert(error); };
        // bluetoothSerial.enable().then(success => {
        //   this.blueStatus = true
        // });
        // this.startScanning()
    }
    BluetoothPage.prototype.ngOnInit = function () {
        // this.plt.ready().then((readySource) => {
        //   this.bluetoothle.enable();
        //   this.bluetoothle.initialize().subscribe(ble => {
        //     console.log('ble', ble.status) // logs 'enabled'
        //   });
        // });
    };
    BluetoothPage.prototype.changeBlueStatus = function () {
        var _this = this;
        this.plt.ready().then(function (readySource) {
            _this.bluetoothle.enable();
            _this.bluetoothle.initialize().subscribe(function (ble) {
                console.log('ble', ble.status); // logs 'enabled'
            });
        });
        this.bluetoothSerial.enable();
        this.startScanning();
        // this.blueStatus = !this.blueStatus
        // if(this.blueStatus === true) {
        //   this.startScanning()
        // } 
    };
    BluetoothPage.prototype.startScanning = function () {
        var _this = this;
        this.pairedDevices = null;
        this.unpairedDevices = null;
        this.gettingDevices = true;
        this.bluetoothSerial.discoverUnpaired().then(function (success) {
            console.log(success);
            _this.gettingDevices = false;
            success.forEach(function (element) {
                // alert(element.name);
            });
        }, function (err) {
            console.log(err);
        });
        this.bluetoothSerial.list().then(function (success) {
            console.log(success);
            _this.unpairedDevices = success;
        }, function (err) {
        });
    };
    BluetoothPage.prototype.selectDevice = function (address) {
        return tslib__WEBPACK_IMPORTED_MODULE_0__["__awaiter"](this, void 0, void 0, function () {
            var alert;
            var _this = this;
            return tslib__WEBPACK_IMPORTED_MODULE_0__["__generator"](this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, this.alertCtrl.create({
                            header: 'Connect',
                            message: 'Do you want to connect with?',
                            buttons: [
                                {
                                    text: 'Cancel',
                                    role: 'cancel',
                                    handler: function () {
                                        console.log('Cancel clicked');
                                    }
                                },
                                {
                                    text: 'Connect',
                                    handler: function () {
                                        _this.bluetoothSerial.connect(address).subscribe(_this.success, _this.fail);
                                    }
                                }
                            ]
                        })];
                    case 1:
                        alert = _a.sent();
                        return [4 /*yield*/, alert.present()];
                    case 2:
                        _a.sent();
                        return [2 /*return*/];
                }
            });
        });
    };
    BluetoothPage.prototype.disconnect = function () {
        return tslib__WEBPACK_IMPORTED_MODULE_0__["__awaiter"](this, void 0, void 0, function () {
            var alert;
            var _this = this;
            return tslib__WEBPACK_IMPORTED_MODULE_0__["__generator"](this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, this.alertCtrl.create({
                            header: 'Disconnect?',
                            message: 'Do you want to Disconnect?',
                            buttons: [
                                {
                                    text: 'Cancel',
                                    role: 'cancel',
                                    handler: function () {
                                        console.log('Cancel clicked');
                                    }
                                },
                                {
                                    text: 'Disconnect',
                                    handler: function () {
                                        _this.bluetoothSerial.disconnect();
                                    }
                                }
                            ]
                        })];
                    case 1:
                        alert = _a.sent();
                        return [4 /*yield*/, alert.present()];
                    case 2:
                        _a.sent();
                        return [2 /*return*/];
                }
            });
        });
    };
    BluetoothPage.prototype.sendDataToSerial = function () {
        // this.bluetoothSerial.write(`{D0931,0480,0601|}
        // {C|}
        // {PC00;0071,0131,1,1,A,00,B=Örnek Yazı|}
        // {LC;0000,0180,0480,0185,0,3|}
        // {XB00;0091,0440,A,3,03,0,0128,+0000000000,000,1,00=>512345678|}
        // {XS;I,0001,0002C1011|}`)
        this.bluetoothSerial.write(this.write());
        // this.bluetoothSerial.write([186, 220, 222])
        // var data = new Uint8Array(4);
        // data[0] = 0x41;
        // data[1] = 0x42;
        // data[2] = 0x43;
        // data[3] = 0x44;
        // this.bluetoothSerial.write(data)
        // this.bluetoothSerial.write(data.buffer)
    };
    BluetoothPage.prototype.declareLabelSize = function (pitchLengthOfLabel, effectivePrintWidth, effectivePrintLength) {
        return '{D' + pitchLengthOfLabel + ',' + effectivePrintWidth + ',' + effectivePrintLength + '|}';
    };
    BluetoothPage.prototype.cleanBuffer = function () {
        return '{C|}';
    };
    BluetoothPage.prototype.printWriteCommand = function (id, x, y, text) {
        // {PC000;0071,0131,1,1,S,00,B=Ornek Yaz|}  
        return '{PC' + id + ';' + y + ',' + x + ',' + '1' + ',' + '1' + ',' + 'O' + ',' + '00' + ',' + 'B=' + text + '|}';
    };
    BluetoothPage.prototype.printDrawLine = function (xStartPoint, yStartPoint, xEndPoint, yEndPoint) {
        return '{LC;' + yStartPoint + ',' + xStartPoint + ',' + yEndPoint + ',' + xEndPoint + ',' + '0' + ',' + '3|}';
    };
    BluetoothPage.prototype.generateBarcode = function (barcodeTotalNumber, x, y, rotationAngleOfBarcode, barcodeNumber) {
        // {XB00;0091,0440,A,3,03,0,0128,+0000000000,000,1,00=>512345678|}
        return '{XB' + barcodeTotalNumber + ';' + x + ',' + y + ',' + 'A,3,03,' + rotationAngleOfBarcode + ',0128,+0000000000,000,1,00=>5' + barcodeNumber + '|}';
    };
    BluetoothPage.prototype.printConditions = function () {
        return '{XS;I,0001,0002C1011|}';
    };
    BluetoothPage.prototype.write = function () {
        var toshibaPrintScript = this.declareLabelSize('0700', '0700', '0690') +
            this.cleanBuffer() +
            this.printWriteCommand('00', '0050', '0010', 'Gonderici Adresi') +
            this.printWriteCommand('01', '0100', '0010', 'Resitpasa Mahallesi Katar Caddesi') +
            this.printWriteCommand('02', '0150', '0010', 'No:4/B3 Sariyer/Istanbul') +
            this.printDrawLine('0160', '0000', '0160', '2000') +
            this.printWriteCommand('03', '0200', '0010', 'Alici Adresi') +
            this.printWriteCommand('04', '0250', '0010', 'Yenikoy Mahallesi Doganlar Caddesi') +
            this.printWriteCommand('05', '0300', '0010', 'No:12/2 Savsat/Artvin') +
            this.printDrawLine('0310', '0000', '0310', '2000') +
            this.generateBarcode('00', '0200', '0460', '0', '12345678') +
            this.printConditions();
        return toshibaPrintScript;
    };
    BluetoothPage = tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"]([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["Component"])({
            selector: 'app-bluetooth',
            template: __webpack_require__(/*! ./bluetooth.page.html */ "./src/app/bluetooth/bluetooth.page.html"),
            styles: [__webpack_require__(/*! ./bluetooth.page.scss */ "./src/app/bluetooth/bluetooth.page.scss")]
        }),
        tslib__WEBPACK_IMPORTED_MODULE_0__["__metadata"]("design:paramtypes", [_ionic_native_bluetooth_serial_ngx__WEBPACK_IMPORTED_MODULE_2__["BluetoothSerial"],
            _ionic_angular__WEBPACK_IMPORTED_MODULE_4__["AlertController"],
            _ionic_native_bluetooth_le_ngx__WEBPACK_IMPORTED_MODULE_3__["BluetoothLE"],
            _ionic_angular__WEBPACK_IMPORTED_MODULE_4__["Platform"]])
    ], BluetoothPage);
    return BluetoothPage;
}());



/***/ })

}]);
//# sourceMappingURL=bluetooth-bluetooth-module.js.map