(window["webpackJsonp"] = window["webpackJsonp"] || []).push([["contract-table-contract-table-module"],{

/***/ "./src/app/contract-table/contract-table.module.ts":
/*!*********************************************************!*\
  !*** ./src/app/contract-table/contract-table.module.ts ***!
  \*********************************************************/
/*! exports provided: ContractTablePageModule */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ContractTablePageModule", function() { return ContractTablePageModule; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ "./node_modules/@angular/core/fesm5/core.js");
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/common */ "./node_modules/@angular/common/fesm5/common.js");
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/forms */ "./node_modules/@angular/forms/fesm5/forms.js");
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @angular/router */ "./node_modules/@angular/router/fesm5/router.js");
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @ionic/angular */ "./node_modules/@ionic/angular/dist/fesm5.js");
/* harmony import */ var _contract_table_page__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./contract-table.page */ "./src/app/contract-table/contract-table.page.ts");







var routes = [
    {
        path: '',
        component: _contract_table_page__WEBPACK_IMPORTED_MODULE_6__["ContractTablePage"]
    }
];
var ContractTablePageModule = /** @class */ (function () {
    function ContractTablePageModule() {
    }
    ContractTablePageModule = tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"]([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["NgModule"])({
            imports: [
                _angular_common__WEBPACK_IMPORTED_MODULE_2__["CommonModule"],
                _angular_forms__WEBPACK_IMPORTED_MODULE_3__["FormsModule"],
                _ionic_angular__WEBPACK_IMPORTED_MODULE_5__["IonicModule"],
                _angular_router__WEBPACK_IMPORTED_MODULE_4__["RouterModule"].forChild(routes)
            ],
            declarations: [_contract_table_page__WEBPACK_IMPORTED_MODULE_6__["ContractTablePage"]]
        })
    ], ContractTablePageModule);
    return ContractTablePageModule;
}());



/***/ }),

/***/ "./src/app/contract-table/contract-table.page.html":
/*!*********************************************************!*\
  !*** ./src/app/contract-table/contract-table.page.html ***!
  \*********************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = "<ion-header>\r\n  <ion-toolbar>\r\n    <ion-buttons slot=\"start\">\r\n      <ion-back-button [defaultHref]=\"defaultHref\"></ion-back-button>\r\n    </ion-buttons>\r\n    <ion-title>采购合同列表</ion-title>\r\n  </ion-toolbar>\r\n</ion-header>\r\n\r\n<ion-content>\r\n  <ion-refresher slot=\"fixed\" (ionRefresh)=\"doRefresh($event)\">\r\n    <ion-refresher-content pullingIcon=\"arrow-dropdown\" pullingText=\"加载中...\" refreshingSpinner=\"circles\"\r\n      refreshingText=\"刷新...\">\r\n    </ion-refresher-content>\r\n  </ion-refresher>\r\n  <ion-card *ngFor=\"let contract of contractList\" (click)=\"getDetail(contract)\">\r\n    <ion-card-content class=\"contract-content\">\r\n      <!--        <div class=\"contract-column\">-->\r\n      <!--          <ion-icon name=\"contract\"></ion-icon>-->\r\n      <!--          <ion-label>采购合同ID： </ion-label>-->\r\n      <!--          <ion-label>{{contract.sscId}}</ion-label>-->\r\n      <!--        </div>-->\r\n      <div class=\"contract-column\">\r\n        <ion-icon name=\"folder\"></ion-icon>\r\n        <ion-label>采购合同编号： </ion-label>\r\n        <ion-label>{{contract.sscCode}}</ion-label>\r\n      </div>\r\n      <!-- <div class=\"contract-column\">\r\n          <ion-icon name=\"time\"></ion-icon>\r\n          <ion-label>供应商编号：{{contract.sid}}</ion-label>\r\n          <ion-label></ion-label>\r\n        </div>\r\n        <div class=\"contract-column\">\r\n          <ion-icon name=\"business\"></ion-icon>\r\n          <ion-label>供应商名称： </ion-label>\r\n          <ion-label>{{contract.sdSelf}}</ion-label>\r\n        </div> -->\r\n      <div class=\"contract-column\">\r\n        <ion-icon name=\"calendar\"></ion-icon>\r\n        <ion-label>合同日期： </ion-label>\r\n        <ion-label>{{contract.sscContractdate}}</ion-label>\r\n      </div>\r\n      <div class=\"contract-column\">\r\n        <ion-icon name=\"man\"></ion-icon>\r\n        <ion-label>下单员： </ion-label>\r\n        <ion-label>{{contract.sscCreator}}</ion-label>\r\n      </div>\r\n      <div class=\"contract-title\">\r\n        <ion-icon name=\"flag\"></ion-icon>\r\n        <ion-label>注备：</ion-label>\r\n        <ion-label>{{contract.sscCnremark}}</ion-label>\r\n      </div>\r\n    </ion-card-content>\r\n  </ion-card>\r\n  <ion-infinite-scroll #IonInfiniteScroll threshold=\"100px\" (ionInfinite)=\"loadData($event)\">\r\n    <ion-infinite-scroll-content loadingSpinner=\"bubbles\" loadingText=\"加载...\">\r\n    </ion-infinite-scroll-content>\r\n  </ion-infinite-scroll>\r\n</ion-content>\r\n"

/***/ }),

/***/ "./src/app/contract-table/contract-table.page.scss":
/*!*********************************************************!*\
  !*** ./src/app/contract-table/contract-table.page.scss ***!
  \*********************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = "\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IiIsImZpbGUiOiJzcmMvYXBwL2NvbnRyYWN0LXRhYmxlL2NvbnRyYWN0LXRhYmxlLnBhZ2Uuc2NzcyJ9 */"

/***/ }),

/***/ "./src/app/contract-table/contract-table.page.ts":
/*!*******************************************************!*\
  !*** ./src/app/contract-table/contract-table.page.ts ***!
  \*******************************************************/
/*! exports provided: ContractTablePage */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ContractTablePage", function() { return ContractTablePage; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ "./node_modules/@angular/core/fesm5/core.js");
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/router */ "./node_modules/@angular/router/fesm5/router.js");
/* harmony import */ var _ionic_storage__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @ionic/storage */ "./node_modules/@ionic/storage/fesm5/ionic-storage.js");
/* harmony import */ var _providers_user_data__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../providers/user-data */ "./src/providers/user-data.ts");





var ContractTablePage = /** @class */ (function () {
    function ContractTablePage(router, userData, storage) {
        this.router = router;
        this.userData = userData;
        this.storage = storage;
        this.defaultHref = "";
        this.contractList = [];
        this.total = 0;
        this.queryForm = {};
    }
    ContractTablePage.prototype.ngOnInit = function () {
        this.getTableData();
    };
    ContractTablePage.prototype.ionViewDidEnter = function () {
        this.defaultHref = "/contract";
    };
    ContractTablePage.prototype.getTableData = function () {
        var _this = this;
        this.storage.get('contractForm').then(function (val) { return tslib__WEBPACK_IMPORTED_MODULE_0__["__awaiter"](_this, void 0, void 0, function () {
            var data;
            return tslib__WEBPACK_IMPORTED_MODULE_0__["__generator"](this, function (_a) {
                switch (_a.label) {
                    case 0:
                        if (!val) return [3 /*break*/, 2];
                        this.queryForm = val;
                        return [4 /*yield*/, this.userData.getContractTableData(this.queryForm)];
                    case 1:
                        data = _a.sent();
                        this.total = data.totalElements;
                        this.contractList = data.data;
                        _a.label = 2;
                    case 2: return [2 /*return*/];
                }
            });
        }); });
    };
    ContractTablePage.prototype.doRefresh = function (event) {
        this.getTableData();
        event.target.complete();
    };
    ContractTablePage.prototype.loadData = function (event) {
        return tslib__WEBPACK_IMPORTED_MODULE_0__["__awaiter"](this, void 0, void 0, function () {
            var data;
            return tslib__WEBPACK_IMPORTED_MODULE_0__["__generator"](this, function (_a) {
                switch (_a.label) {
                    case 0:
                        this.queryForm['size'] += 10;
                        return [4 /*yield*/, this.userData.getContractTableData(this.queryForm)];
                    case 1:
                        data = _a.sent();
                        this.total = data.totalElements;
                        this.contractList = data.data;
                        event.target.complete();
                        if (this.total < this.queryForm['size']) {
                            event.target.disabled = true;
                        }
                        return [2 /*return*/];
                }
            });
        });
    };
    ContractTablePage.prototype.getDetail = function (contract) {
        var _this = this;
        this.storage.set('sscId', contract.sscId).then(function () {
            _this.router.navigateByUrl('/contract-detail');
        });
        // this.storage.set('sdDocument',sample.sdDocument)
    };
    ContractTablePage = tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"]([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["Component"])({
            selector: 'app-contract-table',
            template: __webpack_require__(/*! ./contract-table.page.html */ "./src/app/contract-table/contract-table.page.html"),
            styles: [__webpack_require__(/*! ./contract-table.page.scss */ "./src/app/contract-table/contract-table.page.scss")]
        }),
        tslib__WEBPACK_IMPORTED_MODULE_0__["__metadata"]("design:paramtypes", [_angular_router__WEBPACK_IMPORTED_MODULE_2__["Router"],
            _providers_user_data__WEBPACK_IMPORTED_MODULE_4__["UserData"],
            _ionic_storage__WEBPACK_IMPORTED_MODULE_3__["Storage"]])
    ], ContractTablePage);
    return ContractTablePage;
}());



/***/ })

}]);
//# sourceMappingURL=contract-table-contract-table-module.js.map