(window["webpackJsonp"] = window["webpackJsonp"] || []).push([["store-qc-scanning-store-qc-scanning-module"],{

/***/ "./src/app/store-qc-scanning/store-qc-scanning.module.ts":
/*!***************************************************************!*\
  !*** ./src/app/store-qc-scanning/store-qc-scanning.module.ts ***!
  \***************************************************************/
/*! exports provided: StoreQCScanningPageModule */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "StoreQCScanningPageModule", function() { return StoreQCScanningPageModule; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ "./node_modules/@angular/core/fesm5/core.js");
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/common */ "./node_modules/@angular/common/fesm5/common.js");
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/forms */ "./node_modules/@angular/forms/fesm5/forms.js");
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @angular/router */ "./node_modules/@angular/router/fesm5/router.js");
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @ionic/angular */ "./node_modules/@ionic/angular/dist/fesm5.js");
/* harmony import */ var _store_qc_scanning_page__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./store-qc-scanning.page */ "./src/app/store-qc-scanning/store-qc-scanning.page.ts");







var routes = [
    {
        path: '',
        component: _store_qc_scanning_page__WEBPACK_IMPORTED_MODULE_6__["StoreQCScanningPage"]
    }
];
var StoreQCScanningPageModule = /** @class */ (function () {
    function StoreQCScanningPageModule() {
    }
    StoreQCScanningPageModule = tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"]([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["NgModule"])({
            imports: [
                _angular_common__WEBPACK_IMPORTED_MODULE_2__["CommonModule"],
                _angular_forms__WEBPACK_IMPORTED_MODULE_3__["FormsModule"],
                _ionic_angular__WEBPACK_IMPORTED_MODULE_5__["IonicModule"],
                _angular_router__WEBPACK_IMPORTED_MODULE_4__["RouterModule"].forChild(routes)
            ],
            declarations: [_store_qc_scanning_page__WEBPACK_IMPORTED_MODULE_6__["StoreQCScanningPage"]]
        })
    ], StoreQCScanningPageModule);
    return StoreQCScanningPageModule;
}());



/***/ }),

/***/ "./src/app/store-qc-scanning/store-qc-scanning.page.html":
/*!***************************************************************!*\
  !*** ./src/app/store-qc-scanning/store-qc-scanning.page.html ***!
  \***************************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = "<ion-header>\n  <ion-toolbar>\n    <ion-buttons slot=\"start\" *ngIf=\"!defaultHref\">\n      <ion-menu-button></ion-menu-button>\n    </ion-buttons>\n    <ion-buttons slot=\"start\" *ngIf=\"defaultHref\">\n      <ion-back-button [defaultHref]=\"defaultHref\"></ion-back-button>\n    </ion-buttons>\n    <ion-title>QC扫描</ion-title>\n    <ion-buttons slot=\"end\">\n      <ion-button [disabled]=\"storeQCList.length===0\" (click)=\"generateQC()\">\n        生成\n      </ion-button>\n      /\n      <ion-button (click)=\"qrscan()\">\n        <ion-icon name=\"qr-scanner\"></ion-icon>\n      </ion-button>\n    </ion-buttons>\n  </ion-toolbar>\n</ion-header>\n\n<ion-content>\n  <ion-item>\n    <ion-label>条形码编号:</ion-label>\n    <ion-input #scanInput clear-on-edit (ionChange)=\"getStoreQCDetail()\" [(ngModel)]=\"scanCode\"></ion-input>\n  </ion-item>\n  <ion-list *ngFor=\"let qc of storeQCDetailList\">\n    <ion-item-group>\n      <ion-item-divider sticky>\n        <ion-label>\n          初检单详情\n        </ion-label>\n      </ion-item-divider>\n    </ion-item-group>\n    <ion-item>\n      <ion-label>\n        我司货号：\n      </ion-label>\n      <ion-input [(ngModel)]=\"qc.scpCode\"></ion-input>\n    </ion-item>\n    <ion-item>\n      <ion-label>\n        客户货号：\n      </ion-label>\n      <ion-input [(ngModel)]=\"qc.scpCustomercode\"></ion-input>\n    </ion-item>\n    <ion-item>\n      <ion-label>\n        中文品名：\n      </ion-label>\n      <ion-input [(ngModel)]=\"qc.scpCnname\"></ion-input>\n    </ion-item>\n    <ion-item>\n      <ion-label>\n        抽检箱数：\n      </ion-label>\n      <ion-input [(ngModel)]=\"qc.checkboxcount\"></ion-input>\n    </ion-item>\n    <ion-item>\n      <ion-label>\n        抽检数量：\n      </ion-label>\n      <ion-input [(ngModel)]=\"qc.checkcount\"></ion-input>\n    </ion-item>\n    <ion-item>\n      <ion-label>\n        瑕疵数量：\n      </ion-label>\n      <ion-input [(ngModel)]=\"qc.badcount\"></ion-input>\n    </ion-item>\n    <ion-item>\n      <ion-label>\n        处理意见：\n      </ion-label>\n      <ion-item slot=\"end\">\n        <ion-checkbox [(ngModel)]=\"qc.deal\" readonly></ion-checkbox>\n        <ion-label *ngIf=\"qc.deal\">通过</ion-label>\n        <ion-label *ngIf=\"!qc.deal\" color=\"danger\">未通过</ion-label>\n      </ion-item>\n    </ion-item>\n    <ion-item>\n      <ion-label>\n        QA日志：\n      </ion-label>\n      <ion-textarea [(ngModel)]=\"qc.qalog\" readonly></ion-textarea>\n      <!-- <ion-icon name=\"camera\" slot=\"end\" (click)=\"takePicture(qc)\"></ion-icon> -->\n    </ion-item>\n    <ion-item>\n      <ion-label>qa日志图片：</ion-label>\n      <ion-thumbnail *ngFor=\"let photo of qc.qaimgList index as i\">\n        <ion-img [src]=\"photo\" (click)=\"showFullScreenImage(photo)\">\n        </ion-img>\n      </ion-thumbnail>\n      <!-- <ion-icon *ngIf=\"qc.showPicture\" name=\"close-circle-outline\" (click)=\"deletePicture(qc)\" slot=\"end\"> -->\n      <!-- </ion-icon> -->\n    </ion-item>\n    <ion-item>\n      <ion-label>\n        QC日志：\n      </ion-label>\n      <ion-textarea [(ngModel)]=\"qc.qclog\"></ion-textarea>\n      <ion-icon name=\"cloud-upload\" slot=\"end\" (click)=\"choosePicture(qc)\"></ion-icon>\n      <ion-icon name=\"camera\" slot=\"end\" (click)=\"takePicture(qc)\"></ion-icon>\n    </ion-item>\n    <ion-item>\n      <ion-label>QC日志图片：</ion-label>\n      <ion-thumbnail *ngFor=\"let photo of qc.qcimgList index as i\">\n        <ion-icon name=\"close-circle-outline\" (click)=\"deletePicture(qc, i)\"></ion-icon>\n        <ion-img [src]=\"photo\" (click)=\"showFullScreenImage(photo)\">\n        </ion-img>\n      </ion-thumbnail>\n    </ion-item>\n    <!-- <ion-item>\n      <ion-label>\n        跟单备注：\n      </ion-label>\n      <ion-input [(ngModel)]=\"qc.remark\"></ion-input>\n      <ion-icon name=\"camera\" slot=\"end\" (click)=\"takePicture(qc)\"></ion-icon>\n    </ion-item>\n    <ion-item>\n      <ion-label>备注图片：</ion-label>\n      <ion-thumbnail *ngIf=\"qc.imgUrl\">\n        <ion-img [src]=\"qc.imgUrl\"></ion-img>\n      </ion-thumbnail>\n      <ion-icon *ngIf=\"qc.imgUrl\" name=\"close-circle-outline\" (click)=\"deletePicture(qc)\" slot=\"end\">\n      </ion-icon>\n    </ion-item> -->\n  </ion-list>\n  <div class=\"ion-padding\">\n    <ion-button [disabled]=\"storeQCDetailList.length===0\" color=\"primary\" type=\"submit\" expand=\"block\"\n      (click)=\"saveQCRecord()\">\n      记 录</ion-button>\n  </div>\n  <ion-list>\n    <ion-item-group>\n      <ion-item-divider sticky>\n        <ion-label>\n          已扫描条形码编号\n        </ion-label>\n      </ion-item-divider>\n    </ion-item-group>\n    <ion-item *ngFor=\"let item of storeQCList index as i\">\n      <ion-label color=\"primary\" (click)=\"getStoreQCDetail(item)\">{{item.scpCode}}({{item.scanCode}})</ion-label>\n      <ion-icon name=\"trash\" (click)=\"deleteQCStore(item, i)\"></ion-icon>\n    </ion-item>\n  </ion-list>\n</ion-content>"

/***/ }),

/***/ "./src/app/store-qc-scanning/store-qc-scanning.page.scss":
/*!***************************************************************!*\
  !*** ./src/app/store-qc-scanning/store-qc-scanning.page.scss ***!
  \***************************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = "\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IiIsImZpbGUiOiJzcmMvYXBwL3N0b3JlLXFjLXNjYW5uaW5nL3N0b3JlLXFjLXNjYW5uaW5nLnBhZ2Uuc2NzcyJ9 */"

/***/ }),

/***/ "./src/app/store-qc-scanning/store-qc-scanning.page.ts":
/*!*************************************************************!*\
  !*** ./src/app/store-qc-scanning/store-qc-scanning.page.ts ***!
  \*************************************************************/
/*! exports provided: StoreQCScanningPage */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "StoreQCScanningPage", function() { return StoreQCScanningPage; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ "./node_modules/@angular/core/fesm5/core.js");
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/router */ "./node_modules/@angular/router/fesm5/router.js");
/* harmony import */ var _ionic_storage__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @ionic/storage */ "./node_modules/@ionic/storage/fesm5/ionic-storage.js");
/* harmony import */ var _ionic_native_keyboard_ngx__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @ionic-native/keyboard/ngx */ "./node_modules/@ionic-native/keyboard/ngx/index.js");
/* harmony import */ var _providers_user_data__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../providers/user-data */ "./src/providers/user-data.ts");
/* harmony import */ var _ionic_native_camera_ngx__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @ionic-native/camera/ngx */ "./node_modules/@ionic-native/camera/ngx/index.js");
/* harmony import */ var _providers_camera_photo__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../providers/camera-photo */ "./src/providers/camera-photo.ts");
/* harmony import */ var _providers_common_service__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../providers/common.service */ "./src/providers/common.service.ts");
/* harmony import */ var _ionic_native_barcode_scanner_ngx__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @ionic-native/barcode-scanner/ngx */ "./node_modules/@ionic-native/barcode-scanner/ngx/index.js");











var StoreQCScanningPage = /** @class */ (function () {
    function StoreQCScanningPage(router, barcodeScanner, activeRoute, commonService, cameraSetting, storage, userData, camera, keyboard) {
        this.router = router;
        this.barcodeScanner = barcodeScanner;
        this.activeRoute = activeRoute;
        this.commonService = commonService;
        this.cameraSetting = cameraSetting;
        this.storage = storage;
        this.userData = userData;
        this.camera = camera;
        this.keyboard = keyboard;
        this.scanCode = '';
        this.storeQCList = [];
        this.defaultHref = '';
        this.storeQCDetailList = [];
    }
    StoreQCScanningPage.prototype.ngOnInit = function () {
        var _this = this;
        this.storage.get('storeQCList').then(function (val) { return tslib__WEBPACK_IMPORTED_MODULE_0__["__awaiter"](_this, void 0, void 0, function () {
            return tslib__WEBPACK_IMPORTED_MODULE_0__["__generator"](this, function (_a) {
                if (val) {
                    this.storeQCList = JSON.parse(val);
                }
                return [2 /*return*/];
            });
        }); });
    };
    StoreQCScanningPage.prototype.ionViewDidEnter = function () {
        var _this = this;
        this.activeRoute.paramMap.subscribe(function (params) {
            if (params['params'].sscId && params['params'].pId) {
                _this.scanCode = params['params'].sscId + '_' + params['params'].pId;
                _this.defaultHref = '/store-pending';
            }
            else {
                _this.scanCode = '';
            }
            // this.product = products[+params.get('productId')];
        });
        // this.initialData()
    };
    StoreQCScanningPage.prototype.ionViewDidLeave = function () {
        if (this.storeQCList.length !== 0) {
            this.storage.set('storeQCList', JSON.stringify(this.storeQCList));
        }
        else {
            this.storage.remove('storeQCList');
        }
    };
    StoreQCScanningPage.prototype.initialData = function () {
        this.storeQCDetailList = [];
        this.scanInput.setFocus();
        // this.storage.get('store-pending').then(async (val) => {
        //   if(val) {
        //     this.scanCode = val.sscId + '_' +val.pid
        //     this.defaultHref = '/store-pending'
        //   } else {
        //     this.defaultHref = ''
        //   }
        // })
        this.scanCode = '';
    };
    StoreQCScanningPage.prototype.showFullScreenImage = function (data) {
        this.commonService.fullScreenImg(data);
    };
    // 获取扫描详情
    StoreQCScanningPage.prototype.getStoreQCDetail = function (item) {
        return tslib__WEBPACK_IMPORTED_MODULE_0__["__awaiter"](this, void 0, void 0, function () {
            var filterData, data, _i, _a, i, qalogdata, qclogdata, _b, _c, j;
            var _this = this;
            return tslib__WEBPACK_IMPORTED_MODULE_0__["__generator"](this, function (_d) {
                switch (_d.label) {
                    case 0:
                        this.storeQCDetailList = [];
                        this.keyboard.hide();
                        if (!item) return [3 /*break*/, 1];
                        this.scanCode = item.scanCode;
                        this.storeQCDetailList = item;
                        return [3 /*break*/, 9];
                    case 1:
                        if (!(this.scanCode.split('_').length === 2)) return [3 /*break*/, 9];
                        filterData = [];
                        filterData = this.storeQCList.filter(function (item) { return item.sscId == _this.scanCode.split('_')[0] && item.pid == _this.scanCode.split('_')[1]; });
                        if (!(filterData.length !== 0)) return [3 /*break*/, 2];
                        this.storeQCDetailList = filterData;
                        return [3 /*break*/, 4];
                    case 2: return [4 /*yield*/, this.userData.getQCDetail(Number(this.scanCode.split('_')[0]), Number(this.scanCode.split('_')[1]))];
                    case 3:
                        data = _d.sent();
                        this.storeQCDetailList = new Array(data);
                        _d.label = 4;
                    case 4:
                        _i = 0, _a = this.storeQCDetailList;
                        _d.label = 5;
                    case 5:
                        if (!(_i < _a.length)) return [3 /*break*/, 9];
                        i = _a[_i];
                        i.qaimgList = [];
                        i.qcimgList = [];
                        i['qcIdList'] = [];
                        return [4 /*yield*/, this.userData.getQAlog(i.sscId, i.pid)];
                    case 6:
                        qalogdata = _d.sent();
                        if (JSON.parse(qalogdata).data.length !== 0) {
                            i.qalog = JSON.parse(qalogdata).data[0].mark;
                            i.qaimgList = JSON.parse(qalogdata).data[0].picture.split(",");
                        }
                        return [4 /*yield*/, this.userData.getQClog(i.sscId, i.pid)];
                    case 7:
                        qclogdata = _d.sent();
                        if (JSON.parse(qclogdata).data.length !== 0) {
                            for (_b = 0, _c = JSON.parse(qclogdata).data; _b < _c.length; _b++) {
                                j = _c[_b];
                                i['qcIdList'].push(j.id); // qc记录的id数组
                            }
                            i.qclog = JSON.parse(qclogdata).data[0].mark;
                            i.qcimgList = JSON.parse(qclogdata).data[0].picture.split(",");
                            i.imageData = JSON.parse(qclogdata).data[0].picture;
                            // i.qcimgUrl = JSON.parse(qclogdata).data[0].picture.split(",")[0]
                        }
                        // 处理意见转换boolean(无deal)
                        if (i.deal === undefined) {
                            if (i.dealpropose == 1) {
                                i.deal = true;
                            }
                            else {
                                i.deal = false;
                            }
                        }
                        _d.label = 8;
                    case 8:
                        _i++;
                        return [3 /*break*/, 5];
                    case 9: return [2 /*return*/];
                }
            });
        });
    };
    // 生成QC验货初检报告
    StoreQCScanningPage.prototype.generateQC = function () {
        return tslib__WEBPACK_IMPORTED_MODULE_0__["__awaiter"](this, void 0, void 0, function () {
            var _i, _a, i;
            return tslib__WEBPACK_IMPORTED_MODULE_0__["__generator"](this, function (_b) {
                switch (_b.label) {
                    case 0:
                        for (_i = 0, _a = this.storeQCList; _i < _a.length; _i++) {
                            i = _a[_i];
                            if (i.deal) {
                                i.dealpropose = 1;
                            }
                            else {
                                i.dealpropose = 0;
                            }
                        }
                        return [4 /*yield*/, this.userData.createQC(this.storeQCList)];
                    case 1:
                        _b.sent();
                        this.initialData();
                        this.storage.remove('storeQCList');
                        this.storeQCList = [];
                        return [2 /*return*/];
                }
            });
        });
    };
    // 记录数据
    StoreQCScanningPage.prototype.saveQCRecord = function () {
        return tslib__WEBPACK_IMPORTED_MODULE_0__["__awaiter"](this, void 0, void 0, function () {
            var filterData, _i, _a, i;
            var _this = this;
            return tslib__WEBPACK_IMPORTED_MODULE_0__["__generator"](this, function (_b) {
                filterData = [];
                filterData = this.storeQCList.filter(function (item) {
                    return item.sscId == _this.storeQCDetailList[0].sscId && item.pid == _this.storeQCDetailList[0].pid;
                });
                // 有则更新
                if (filterData.length !== 0) {
                    filterData = this.storeQCDetailList;
                    // 无则加上
                }
                else {
                    this.storeQCList = this.storeQCList.concat(this.storeQCDetailList);
                }
                // 显示记录中的外销合同号
                // this.scpCodes = []
                for (_i = 0, _a = this.storeQCList; _i < _a.length; _i++) {
                    i = _a[_i];
                    if (!i.scanCode) {
                        i.scanCode = this.scanCode; // 无scancode则加上
                    }
                    // this.scpCodes.push(i.scpCode)
                }
                this.addQClog();
                this.initialData();
                return [2 /*return*/];
            });
        });
    };
    // 添加qc记录
    StoreQCScanningPage.prototype.addQClog = function () {
        return tslib__WEBPACK_IMPORTED_MODULE_0__["__awaiter"](this, void 0, void 0, function () {
            var _i, _a, i, _b, _c, j, form;
            return tslib__WEBPACK_IMPORTED_MODULE_0__["__generator"](this, function (_d) {
                switch (_d.label) {
                    case 0:
                        _i = 0, _a = this.storeQCDetailList;
                        _d.label = 1;
                    case 1:
                        if (!(_i < _a.length)) return [3 /*break*/, 4];
                        i = _a[_i];
                        for (_b = 0, _c = i['qcIdList']; _b < _c.length; _b++) {
                            j = _c[_b];
                            this.userData.deleteSampleQc(j);
                        }
                        if (!(i.qclog && i.imageData)) return [3 /*break*/, 3];
                        form = {
                            files: i.imageData,
                            mark: i.qclog,
                            pId: i.pid,
                            sscId: i.sscId
                        };
                        return [4 /*yield*/, this.userData.addQClog(form)];
                    case 2:
                        _d.sent();
                        _d.label = 3;
                    case 3:
                        _i++;
                        return [3 /*break*/, 1];
                    case 4: return [2 /*return*/];
                }
            });
        });
    };
    StoreQCScanningPage.prototype.choosePicture = function (qc) {
        this.showPicture(qc, this.cameraSetting.albumOption);
    };
    StoreQCScanningPage.prototype.takePicture = function (qc) {
        this.showPicture(qc, this.cameraSetting.takePhotoOption);
    };
    StoreQCScanningPage.prototype.showPicture = function (qc, options) {
        this.camera.getPicture(options).then(function (imageData) {
            qc.qcimgList.push('data:image/png;base64,' + imageData);
            if (qc.imageData) {
                qc.imageData = qc.imageData + ',' + imageData;
            }
            else {
                qc.imageData = '' + imageData;
            }
        }, function (err) {
            // Handle error
            console.log("Camera issue: " + err);
        });
    };
    StoreQCScanningPage.prototype.qrscan = function () {
        var _this = this;
        this.barcodeScanner.scan().then(function (barcodeData) {
            _this.scanCode = barcodeData.text;
        }).catch(function (err) {
            console.log('Error', err);
        });
    };
    StoreQCScanningPage.prototype.deletePicture = function (qc, index) {
        qc.qcimgList.splice(index, 1);
        var arr = qc.imageData.split(',');
        arr.splice(qc, 1);
        qc.imageData = arr.toString();
    };
    StoreQCScanningPage.prototype.deleteQCStore = function (store, index) {
        this.storeQCList.splice(index, 1);
    };
    tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"]([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ViewChild"])('scanInput'),
        tslib__WEBPACK_IMPORTED_MODULE_0__["__metadata"]("design:type", Object)
    ], StoreQCScanningPage.prototype, "scanInput", void 0);
    StoreQCScanningPage = tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"]([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["Component"])({
            selector: 'app-store-qc-scanning',
            template: __webpack_require__(/*! ./store-qc-scanning.page.html */ "./src/app/store-qc-scanning/store-qc-scanning.page.html"),
            styles: [__webpack_require__(/*! ./store-qc-scanning.page.scss */ "./src/app/store-qc-scanning/store-qc-scanning.page.scss")]
        }),
        tslib__WEBPACK_IMPORTED_MODULE_0__["__metadata"]("design:paramtypes", [_angular_router__WEBPACK_IMPORTED_MODULE_2__["Router"],
            _ionic_native_barcode_scanner_ngx__WEBPACK_IMPORTED_MODULE_9__["BarcodeScanner"],
            _angular_router__WEBPACK_IMPORTED_MODULE_2__["ActivatedRoute"],
            _providers_common_service__WEBPACK_IMPORTED_MODULE_8__["commonService"],
            _providers_camera_photo__WEBPACK_IMPORTED_MODULE_7__["CameraSetting"],
            _ionic_storage__WEBPACK_IMPORTED_MODULE_3__["Storage"],
            _providers_user_data__WEBPACK_IMPORTED_MODULE_5__["UserData"],
            _ionic_native_camera_ngx__WEBPACK_IMPORTED_MODULE_6__["Camera"],
            _ionic_native_keyboard_ngx__WEBPACK_IMPORTED_MODULE_4__["Keyboard"]])
    ], StoreQCScanningPage);
    return StoreQCScanningPage;
}());



/***/ })

}]);
//# sourceMappingURL=store-qc-scanning-store-qc-scanning-module.js.map