(window["webpackJsonp"] = window["webpackJsonp"] || []).push([["store-qc-store-qc-module"],{

/***/ "./src/app/store-qc/store-qc.module.ts":
/*!*********************************************!*\
  !*** ./src/app/store-qc/store-qc.module.ts ***!
  \*********************************************/
/*! exports provided: StoreQCPageModule */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "StoreQCPageModule", function() { return StoreQCPageModule; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ "./node_modules/@angular/core/fesm5/core.js");
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/common */ "./node_modules/@angular/common/fesm5/common.js");
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/forms */ "./node_modules/@angular/forms/fesm5/forms.js");
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @angular/router */ "./node_modules/@angular/router/fesm5/router.js");
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @ionic/angular */ "./node_modules/@ionic/angular/dist/fesm5.js");
/* harmony import */ var _store_qc_page__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./store-qc.page */ "./src/app/store-qc/store-qc.page.ts");







var routes = [
    {
        path: '',
        component: _store_qc_page__WEBPACK_IMPORTED_MODULE_6__["StoreQCPage"]
    }
];
var StoreQCPageModule = /** @class */ (function () {
    function StoreQCPageModule() {
    }
    StoreQCPageModule = tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"]([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["NgModule"])({
            imports: [
                _angular_common__WEBPACK_IMPORTED_MODULE_2__["CommonModule"],
                _angular_forms__WEBPACK_IMPORTED_MODULE_3__["FormsModule"],
                _ionic_angular__WEBPACK_IMPORTED_MODULE_5__["IonicModule"],
                _angular_router__WEBPACK_IMPORTED_MODULE_4__["RouterModule"].forChild(routes)
            ],
            declarations: [_store_qc_page__WEBPACK_IMPORTED_MODULE_6__["StoreQCPage"]]
        })
    ], StoreQCPageModule);
    return StoreQCPageModule;
}());



/***/ }),

/***/ "./src/app/store-qc/store-qc.page.html":
/*!*********************************************!*\
  !*** ./src/app/store-qc/store-qc.page.html ***!
  \*********************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = "<ion-header>\n  <ion-toolbar>\n    <ion-buttons slot=\"start\">\n      <ion-menu-button></ion-menu-button>\n    </ion-buttons>\n    <ion-title>QC验货初检报告</ion-title>\n  </ion-toolbar>\n</ion-header>\n\n<ion-content>\n  <ion-refresher slot=\"fixed\" (ionRefresh)=\"doRefresh($event)\">\n    <ion-refresher-content pullingIcon=\"arrow-dropdown\" pullingText=\"加载中...\" refreshingSpinner=\"circles\"\n      refreshingText=\"刷新...\">\n    </ion-refresher-content>\n  </ion-refresher>\n  <ion-card *ngFor=\"let qc of qcList\" (click)=\"getQCdetail(qc)\">\n    <ion-card-content>\n      <ion-item lines=\"none\">\n        <span class=\"qc-title\">初检报告编号：{{qc.code}}</span>\n      </ion-item>\n      <ion-item>\n        <span>操作人：{{qc.operator}} </span>\n      </ion-item>\n      <ion-item>\n        <span>修改时间：{{qc.modifiedtime}}</span>\n      </ion-item>\n    </ion-card-content>\n  </ion-card>\n  <ion-infinite-scroll #IonInfiniteScroll threshold=\"100px\" (ionInfinite)=\"loadData($event)\">\n      <ion-infinite-scroll-content loadingSpinner=\"bubbles\" loadingText=\"加载...\">\n      </ion-infinite-scroll-content>\n    </ion-infinite-scroll>\n</ion-content>"

/***/ }),

/***/ "./src/app/store-qc/store-qc.page.scss":
/*!*********************************************!*\
  !*** ./src/app/store-qc/store-qc.page.scss ***!
  \*********************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = ".qc-title {\n  color: var(--ion-color-primary, #3880ff); }\n\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbInNyYy9hcHAvc3RvcmUtcWMvRDpcXG15Q29kZVxcc2dBcHAvc3JjXFxhcHBcXHN0b3JlLXFjXFxzdG9yZS1xYy5wYWdlLnNjc3MiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUE7RUFDSSx3Q0FBdUMsRUFBQSIsImZpbGUiOiJzcmMvYXBwL3N0b3JlLXFjL3N0b3JlLXFjLnBhZ2Uuc2NzcyIsInNvdXJjZXNDb250ZW50IjpbIi5xYy10aXRsZSB7XHJcbiAgICBjb2xvcjp2YXIoLS1pb24tY29sb3ItcHJpbWFyeSwgIzM4ODBmZik7XHJcbn0iXX0= */"

/***/ }),

/***/ "./src/app/store-qc/store-qc.page.ts":
/*!*******************************************!*\
  !*** ./src/app/store-qc/store-qc.page.ts ***!
  \*******************************************/
/*! exports provided: StoreQCPage */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "StoreQCPage", function() { return StoreQCPage; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ "./node_modules/@angular/core/fesm5/core.js");
/* harmony import */ var _providers_user_data__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../providers/user-data */ "./src/providers/user-data.ts");
/* harmony import */ var _ionic_storage__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @ionic/storage */ "./node_modules/@ionic/storage/fesm5/ionic-storage.js");
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @angular/router */ "./node_modules/@angular/router/fesm5/router.js");





var StoreQCPage = /** @class */ (function () {
    function StoreQCPage(userData, storage, router) {
        this.userData = userData;
        this.storage = storage;
        this.router = router;
        this.qcList = [];
        this.current = 1;
        this.size = 10;
    }
    StoreQCPage.prototype.ngOnInit = function () {
        this.getList();
    };
    StoreQCPage.prototype.getList = function () {
        return tslib__WEBPACK_IMPORTED_MODULE_0__["__awaiter"](this, void 0, void 0, function () {
            var data;
            return tslib__WEBPACK_IMPORTED_MODULE_0__["__generator"](this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, this.userData.getQCList(this.current, this.size)];
                    case 1:
                        data = _a.sent();
                        this.qcList = data;
                        return [2 /*return*/];
                }
            });
        });
    };
    StoreQCPage.prototype.doRefresh = function (event) {
        return tslib__WEBPACK_IMPORTED_MODULE_0__["__awaiter"](this, void 0, void 0, function () {
            return tslib__WEBPACK_IMPORTED_MODULE_0__["__generator"](this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, this.getList()];
                    case 1:
                        _a.sent();
                        event.target.complete(); //告诉ion-refresher  更新数据
                        return [2 /*return*/];
                }
            });
        });
    };
    StoreQCPage.prototype.getQCdetail = function (details) {
        var _this = this;
        this.storage.set('QCdetails', JSON.stringify(details)).then(function () {
            _this.storage.remove('qc-pId');
            _this.storage.remove('qc-sscId');
            _this.router.navigateByUrl('/store-qc-detail');
        });
    };
    StoreQCPage.prototype.loadData = function (event) {
        return tslib__WEBPACK_IMPORTED_MODULE_0__["__awaiter"](this, void 0, void 0, function () {
            return tslib__WEBPACK_IMPORTED_MODULE_0__["__generator"](this, function (_a) {
                this.size += 10;
                this.getList();
                event.target.complete();
                if (this.qcList.length < this.size) {
                    event.target.disabled = true;
                }
                return [2 /*return*/];
            });
        });
    };
    StoreQCPage = tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"]([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["Component"])({
            selector: 'app-store-qc',
            template: __webpack_require__(/*! ./store-qc.page.html */ "./src/app/store-qc/store-qc.page.html"),
            styles: [__webpack_require__(/*! ./store-qc.page.scss */ "./src/app/store-qc/store-qc.page.scss")]
        }),
        tslib__WEBPACK_IMPORTED_MODULE_0__["__metadata"]("design:paramtypes", [_providers_user_data__WEBPACK_IMPORTED_MODULE_2__["UserData"], _ionic_storage__WEBPACK_IMPORTED_MODULE_3__["Storage"], _angular_router__WEBPACK_IMPORTED_MODULE_4__["Router"]])
    ], StoreQCPage);
    return StoreQCPage;
}());



/***/ })

}]);
//# sourceMappingURL=store-qc-store-qc-module.js.map