(window["webpackJsonp"] = window["webpackJsonp"] || []).push([["store-sample-pending-store-sample-pending-module"],{

/***/ "./src/app/store-sample-pending/store-sample-pending.module.ts":
/*!*********************************************************************!*\
  !*** ./src/app/store-sample-pending/store-sample-pending.module.ts ***!
  \*********************************************************************/
/*! exports provided: StoreSamplePendingPageModule */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "StoreSamplePendingPageModule", function() { return StoreSamplePendingPageModule; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ "./node_modules/@angular/core/fesm5/core.js");
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/common */ "./node_modules/@angular/common/fesm5/common.js");
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/forms */ "./node_modules/@angular/forms/fesm5/forms.js");
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @angular/router */ "./node_modules/@angular/router/fesm5/router.js");
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @ionic/angular */ "./node_modules/@ionic/angular/dist/fesm5.js");
/* harmony import */ var _store_sample_pending_page__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./store-sample-pending.page */ "./src/app/store-sample-pending/store-sample-pending.page.ts");







var routes = [
    {
        path: '',
        component: _store_sample_pending_page__WEBPACK_IMPORTED_MODULE_6__["StoreSamplePendingPage"]
    }
];
var StoreSamplePendingPageModule = /** @class */ (function () {
    function StoreSamplePendingPageModule() {
    }
    StoreSamplePendingPageModule = tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"]([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["NgModule"])({
            imports: [
                _angular_common__WEBPACK_IMPORTED_MODULE_2__["CommonModule"],
                _angular_forms__WEBPACK_IMPORTED_MODULE_3__["FormsModule"],
                _ionic_angular__WEBPACK_IMPORTED_MODULE_5__["IonicModule"],
                _angular_router__WEBPACK_IMPORTED_MODULE_4__["RouterModule"].forChild(routes)
            ],
            declarations: [_store_sample_pending_page__WEBPACK_IMPORTED_MODULE_6__["StoreSamplePendingPage"]]
        })
    ], StoreSamplePendingPageModule);
    return StoreSamplePendingPageModule;
}());



/***/ }),

/***/ "./src/app/store-sample-pending/store-sample-pending.page.html":
/*!*********************************************************************!*\
  !*** ./src/app/store-sample-pending/store-sample-pending.page.html ***!
  \*********************************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = "<ion-header>\r\n  <ion-toolbar>\r\n    <ion-buttons slot=\"start\">\r\n      <ion-menu-button></ion-menu-button>\r\n    </ion-buttons>\r\n    <ion-title>待备样</ion-title>\r\n    <ion-buttons slot=\"end\">\r\n      <ion-button (click)=\"qrscan()\">\r\n        <ion-icon name=\"qr-scanner\"></ion-icon>\r\n      </ion-button>\r\n    </ion-buttons>\r\n  </ion-toolbar>\r\n</ion-header>\r\n\r\n\r\n\r\n\r\n<ion-content>\r\n  <ion-refresher slot=\"fixed\" (ionRefresh)=\"doRefresh($event)\">\r\n    <ion-refresher-content pullingIcon=\"arrow-dropdown\" pullingText=\"加载中...\" refreshingSpinner=\"circles\"\r\n      refreshingText=\"刷新...\">\r\n    </ion-refresher-content>\r\n  </ion-refresher>\r\n\r\n  <ion-item>\r\n    <ion-label>样品扫描备样：</ion-label>\r\n    <ion-input #scanInput clear-on-edit (ionChange)=\"getStoreSampleDetail()\" [(ngModel)]=\"scanCode\"></ion-input>\r\n  </ion-item>\r\n\r\n\r\n  <ion-card *ngFor=\"let storeSample of storeSampleLists\">\r\n\r\n    <ion-card-content class=\"storeSample-content\">\r\n      <ion-item lines=\"none\">\r\n        <span>产品图片:</span>\r\n        <img slot=\"end\" (click)=\"showFullScreenImage(storeSample)\" [src]=\"storeSample.imgsrc\" class=\"title-image\" />\r\n      </ion-item>\r\n      <ion-item>\r\n        <ion-icon name=\"briefcase\"></ion-icon>\r\n        <ion-label>货架：</ion-label>\r\n        <ion-input [(ngModel)]='storeSample.shelves'></ion-input>\r\n      </ion-item>\r\n      <ion-item>\r\n        <ion-icon name=\"square\"></ion-icon>\r\n        <ion-label>货号：</ion-label>\r\n        <ion-input [(ngModel)]='storeSample.code'></ion-input>\r\n      </ion-item>\r\n      <ion-item>\r\n        <ion-icon name=\"checkbox-outline\"></ion-icon>\r\n        <ion-label>状态： </ion-label>\r\n        <ion-input [(ngModel)]=\"storeSample.statusName\" readonly></ion-input>\r\n      </ion-item>\r\n      <ion-item>\r\n        <ion-icon name=\"hand\"></ion-icon>\r\n        是否借出:\r\n        <ion-label>{{storeSample.lendName}}</ion-label>\r\n      </ion-item>\r\n      <!-- <ion-item>\r\n        <ion-icon name=\"calendar\"></ion-icon>\r\n        <ion-label>更新时间： </ion-label>\r\n        <ion-datetime [(ngModel)]=\"storeSample.updatetime\" readonly></ion-datetime>\r\n      </ion-item> -->\r\n      <ion-item>\r\n        <ion-icon name=\"apps\"></ion-icon>\r\n        <ion-label>数量： </ion-label>\r\n        <ion-input [(ngModel)]='storeSample.count'></ion-input>\r\n      </ion-item>\r\n      <div class=\"ion-padding\">\r\n        <ion-button color=\"primary\" type=\"submit\" expand=\"block\" (click)=\"managePending(storeSample)\">\r\n          备样完成</ion-button>\r\n      </div>\r\n    </ion-card-content>\r\n  </ion-card>\r\n  <ion-infinite-scroll #IonInfiniteScroll threshold=\"100px\" (ionInfinite)=\"loadData($event)\">\r\n    <ion-infinite-scroll-content loadingSpinner=\"bubbles\" loadingText=\"加载...\">\r\n    </ion-infinite-scroll-content>\r\n  </ion-infinite-scroll>\r\n</ion-content>"

/***/ }),

/***/ "./src/app/store-sample-pending/store-sample-pending.page.scss":
/*!*********************************************************************!*\
  !*** ./src/app/store-sample-pending/store-sample-pending.page.scss ***!
  \*********************************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = ".title-image {\n  width: auto;\n  height: 60px; }\n\nspan {\n  font-size: 14px; }\n\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbInNyYy9hcHAvc3RvcmUtc2FtcGxlLXBlbmRpbmcvRDpcXG15Q29kZVxcc2dBcHAvc3JjXFxhcHBcXHN0b3JlLXNhbXBsZS1wZW5kaW5nXFxzdG9yZS1zYW1wbGUtcGVuZGluZy5wYWdlLnNjc3MiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUE7RUFDSSxXQUFXO0VBQ1gsWUFBWSxFQUFBOztBQUVoQjtFQUNJLGVBQWUsRUFBQSIsImZpbGUiOiJzcmMvYXBwL3N0b3JlLXNhbXBsZS1wZW5kaW5nL3N0b3JlLXNhbXBsZS1wZW5kaW5nLnBhZ2Uuc2NzcyIsInNvdXJjZXNDb250ZW50IjpbIi50aXRsZS1pbWFnZSB7XHJcbiAgICB3aWR0aDogYXV0bztcclxuICAgIGhlaWdodDogNjBweDtcclxufVxyXG5zcGFuIHtcclxuICAgIGZvbnQtc2l6ZTogMTRweDtcclxufSJdfQ== */"

/***/ }),

/***/ "./src/app/store-sample-pending/store-sample-pending.page.ts":
/*!*******************************************************************!*\
  !*** ./src/app/store-sample-pending/store-sample-pending.page.ts ***!
  \*******************************************************************/
/*! exports provided: StoreSamplePendingPage */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "StoreSamplePendingPage", function() { return StoreSamplePendingPage; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ "./node_modules/@angular/core/fesm5/core.js");
/* harmony import */ var _providers_user_data__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../providers/user-data */ "./src/providers/user-data.ts");
/* harmony import */ var _ionic_native_keyboard_ngx__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @ionic-native/keyboard/ngx */ "./node_modules/@ionic-native/keyboard/ngx/index.js");
/* harmony import */ var _providers_common_service__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../providers/common.service */ "./src/providers/common.service.ts");
/* harmony import */ var _ionic_native_barcode_scanner_ngx__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @ionic-native/barcode-scanner/ngx */ "./node_modules/@ionic-native/barcode-scanner/ngx/index.js");






var StoreSamplePendingPage = /** @class */ (function () {
    function StoreSamplePendingPage(keyboard, barcodeScanner, commonService, userData) {
        this.keyboard = keyboard;
        this.barcodeScanner = barcodeScanner;
        this.commonService = commonService;
        this.userData = userData;
        this.storeSampleLists = [];
        this.current = 1;
        this.size = 10;
    }
    StoreSamplePendingPage.prototype.ngOnInit = function () {
    };
    StoreSamplePendingPage.prototype.ionViewDidEnter = function () {
        this.getList();
    };
    StoreSamplePendingPage.prototype.doRefresh = function (event) {
        return tslib__WEBPACK_IMPORTED_MODULE_0__["__awaiter"](this, void 0, void 0, function () {
            return tslib__WEBPACK_IMPORTED_MODULE_0__["__generator"](this, function (_a) {
                this.getList();
                event.target.complete(); //告诉ion-refresher  更新数据
                return [2 /*return*/];
            });
        });
    };
    StoreSamplePendingPage.prototype.getList = function () {
        return tslib__WEBPACK_IMPORTED_MODULE_0__["__awaiter"](this, void 0, void 0, function () {
            var data, _i, _a, i;
            return tslib__WEBPACK_IMPORTED_MODULE_0__["__generator"](this, function (_b) {
                switch (_b.label) {
                    case 0: return [4 /*yield*/, this.userData.getStoreSamplePendingList(this.current, this.size)];
                    case 1:
                        data = _b.sent();
                        this.storeSampleLists = data;
                        for (_i = 0, _a = this.storeSampleLists; _i < _a.length; _i++) {
                            i = _a[_i];
                            i['lendName'] = i.lend ? '已借出' : '未借出';
                            i['statusName'] = i.active ? '正常' : '已销毁';
                            if (i["pictures"] && i["pictures"].length !== 0) {
                                i["imgsrc"] = i["pictures"][0].smallPicture;
                            }
                        }
                        return [2 /*return*/];
                }
            });
        });
    };
    StoreSamplePendingPage.prototype.showFullScreenImage = function (form) {
        this.commonService.fullScreenImg(form);
    };
    StoreSamplePendingPage.prototype.loadData = function (event) {
        return tslib__WEBPACK_IMPORTED_MODULE_0__["__awaiter"](this, void 0, void 0, function () {
            return tslib__WEBPACK_IMPORTED_MODULE_0__["__generator"](this, function (_a) {
                this.size += 10;
                this.getList();
                event.target.complete();
                if (this.storeSampleLists.length < this.size) {
                    event.target.disabled = true;
                }
                return [2 /*return*/];
            });
        });
    };
    // 通过code获取仓库样品详情
    StoreSamplePendingPage.prototype.getStoreSampleDetail = function () {
        return tslib__WEBPACK_IMPORTED_MODULE_0__["__awaiter"](this, void 0, void 0, function () {
            var data, code;
            return tslib__WEBPACK_IMPORTED_MODULE_0__["__generator"](this, function (_a) {
                switch (_a.label) {
                    case 0:
                        this.keyboard.hide();
                        return [4 /*yield*/, this.userData.getStoreSampleDetail(this.scanCode)];
                    case 1:
                        data = _a.sent();
                        code = JSON.parse(data).data.code;
                        return [4 /*yield*/, this.userData.changeShelfLend(code)];
                    case 2:
                        _a.sent();
                        this.getList();
                        return [2 /*return*/];
                }
            });
        });
    };
    // 备货完成
    StoreSamplePendingPage.prototype.managePending = function (storeSample) {
        return tslib__WEBPACK_IMPORTED_MODULE_0__["__awaiter"](this, void 0, void 0, function () {
            return tslib__WEBPACK_IMPORTED_MODULE_0__["__generator"](this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, this.userData.changeShelfLend(storeSample.code)];
                    case 1:
                        _a.sent();
                        this.getList();
                        return [2 /*return*/];
                }
            });
        });
    };
    StoreSamplePendingPage.prototype.qrscan = function () {
        var _this = this;
        this.barcodeScanner.scan().then(function (barcodeData) {
            _this.scanCode = barcodeData.text;
        }).catch(function (err) {
            console.log('Error', err);
        });
    };
    StoreSamplePendingPage = tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"]([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["Component"])({
            selector: 'app-store-sample-pending',
            template: __webpack_require__(/*! ./store-sample-pending.page.html */ "./src/app/store-sample-pending/store-sample-pending.page.html"),
            styles: [__webpack_require__(/*! ./store-sample-pending.page.scss */ "./src/app/store-sample-pending/store-sample-pending.page.scss")]
        }),
        tslib__WEBPACK_IMPORTED_MODULE_0__["__metadata"]("design:paramtypes", [_ionic_native_keyboard_ngx__WEBPACK_IMPORTED_MODULE_3__["Keyboard"],
            _ionic_native_barcode_scanner_ngx__WEBPACK_IMPORTED_MODULE_5__["BarcodeScanner"],
            _providers_common_service__WEBPACK_IMPORTED_MODULE_4__["commonService"],
            _providers_user_data__WEBPACK_IMPORTED_MODULE_2__["UserData"]])
    ], StoreSamplePendingPage);
    return StoreSamplePendingPage;
}());



/***/ })

}]);
//# sourceMappingURL=store-sample-pending-store-sample-pending-module.js.map