(window["webpackJsonp"] = window["webpackJsonp"] || []).push([["store-sample-store-sample-module"],{

/***/ "./src/app/store-sample/store-sample.module.ts":
/*!*****************************************************!*\
  !*** ./src/app/store-sample/store-sample.module.ts ***!
  \*****************************************************/
/*! exports provided: StoreSamplePageModule */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "StoreSamplePageModule", function() { return StoreSamplePageModule; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ "./node_modules/@angular/core/fesm5/core.js");
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/common */ "./node_modules/@angular/common/fesm5/common.js");
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/forms */ "./node_modules/@angular/forms/fesm5/forms.js");
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @angular/router */ "./node_modules/@angular/router/fesm5/router.js");
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @ionic/angular */ "./node_modules/@ionic/angular/dist/fesm5.js");
/* harmony import */ var _store_sample_page__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./store-sample.page */ "./src/app/store-sample/store-sample.page.ts");







var routes = [
    {
        path: '',
        component: _store_sample_page__WEBPACK_IMPORTED_MODULE_6__["StoreSamplePage"]
    }
];
var StoreSamplePageModule = /** @class */ (function () {
    function StoreSamplePageModule() {
    }
    StoreSamplePageModule = tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"]([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["NgModule"])({
            imports: [
                _angular_common__WEBPACK_IMPORTED_MODULE_2__["CommonModule"],
                _angular_forms__WEBPACK_IMPORTED_MODULE_3__["FormsModule"],
                _ionic_angular__WEBPACK_IMPORTED_MODULE_5__["IonicModule"],
                _angular_router__WEBPACK_IMPORTED_MODULE_4__["RouterModule"].forChild(routes)
            ],
            declarations: [_store_sample_page__WEBPACK_IMPORTED_MODULE_6__["StoreSamplePage"]]
        })
    ], StoreSamplePageModule);
    return StoreSamplePageModule;
}());



/***/ }),

/***/ "./src/app/store-sample/store-sample.page.html":
/*!*****************************************************!*\
  !*** ./src/app/store-sample/store-sample.page.html ***!
  \*****************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = "<ion-header>\n  <ion-toolbar>\n    <ion-buttons slot=\"start\">\n      <ion-menu-button></ion-menu-button>\n    </ion-buttons>\n    <ion-title>仓库样品列表</ion-title>\n  </ion-toolbar>\n</ion-header>\n\n<ion-content>\n  <ion-refresher slot=\"fixed\" (ionRefresh)=\"doRefresh($event)\">\n    <ion-refresher-content pullingIcon=\"arrow-dropdown\" pullingText=\"加载中...\" refreshingSpinner=\"circles\"\n      refreshingText=\"刷新...\">\n    </ion-refresher-content>\n  </ion-refresher>\n  <ion-card *ngFor=\"let storeSample of storeSampleList\">\n    <ion-item-sliding>\n      <ion-item>\n        <ion-card-content class=\"storeSample-content\">\n          <ion-item lines=\"none\">\n            <span>产品图片:</span>\n            <img slot=\"end\" (click)=\"showFullScreenImage(storeSample)\" [src]=\"storeSample.imgsrc\" class=\"title-image\" />\n          </ion-item>\n          <ion-item>\n            <ion-icon name=\"briefcase\"></ion-icon>\n            <ion-label>货架：</ion-label>\n            <ion-input [(ngModel)]='storeSample.shelves'></ion-input>\n          </ion-item>\n          <ion-item>\n            <ion-icon name=\"square\"></ion-icon>\n            <ion-label>货号：</ion-label>\n            <ion-input [(ngModel)]='storeSample.code'></ion-input>\n          </ion-item>\n          <ion-item>\n            <ion-icon name=\"checkbox-outline\"></ion-icon>\n            <ion-label>状态： </ion-label>\n            <ion-input [(ngModel)]=\"storeSample.statusName\" readonly></ion-input>\n          </ion-item>\n          <ion-item>\n            <ion-icon name=\"hand\"></ion-icon>\n            是否借出:\n            <ion-label>{{storeSample.lendName}}</ion-label>\n          </ion-item>\n          <!-- <ion-item>\n            <ion-icon name=\"calendar\"></ion-icon>\n            <ion-label>更新时间： </ion-label>\n            <ion-datetime [(ngModel)]=\"storeSample.updatetime\" readonly></ion-datetime>\n          </ion-item> -->\n          <ion-item>\n            <ion-icon name=\"apps\"></ion-icon>\n            <ion-label>数量： </ion-label>\n            <ion-input [(ngModel)]='storeSample.count'></ion-input>\n          </ion-item>\n        </ion-card-content>\n      </ion-item>\n      <ion-item-options side=\"end\">\n        <ion-item-option (click)=\"lend(storeSample);$event.stopPropagation()\" *ngIf=\"!storeSample.lend\">借出\n        </ion-item-option>\n        <ion-item-option color=\"danger\" (click)=\"destroy(storeSample);$event.stopPropagation()\"\n          *ngIf=\"storeSample.active\">销毁</ion-item-option>\n      </ion-item-options>\n    </ion-item-sliding>\n  </ion-card>\n  <ion-infinite-scroll #IonInfiniteScroll threshold=\"100px\" (ionInfinite)=\"loadData($event)\">\n    <ion-infinite-scroll-content loadingSpinner=\"bubbles\" loadingText=\"加载...\">\n    </ion-infinite-scroll-content>\n  </ion-infinite-scroll>\n</ion-content>"

/***/ }),

/***/ "./src/app/store-sample/store-sample.page.scss":
/*!*****************************************************!*\
  !*** ./src/app/store-sample/store-sample.page.scss ***!
  \*****************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = ".title-image {\n  width: auto;\n  height: 60px; }\n\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbInNyYy9hcHAvc3RvcmUtc2FtcGxlL0Q6XFxteUNvZGVcXHNnQXBwL3NyY1xcYXBwXFxzdG9yZS1zYW1wbGVcXHN0b3JlLXNhbXBsZS5wYWdlLnNjc3MiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUE7RUFDSSxXQUFXO0VBQ1gsWUFBWSxFQUFBIiwiZmlsZSI6InNyYy9hcHAvc3RvcmUtc2FtcGxlL3N0b3JlLXNhbXBsZS5wYWdlLnNjc3MiLCJzb3VyY2VzQ29udGVudCI6WyIudGl0bGUtaW1hZ2Uge1xyXG4gICAgd2lkdGg6IGF1dG87XHJcbiAgICBoZWlnaHQ6IDYwcHg7XHJcbn0iXX0= */"

/***/ }),

/***/ "./src/app/store-sample/store-sample.page.ts":
/*!***************************************************!*\
  !*** ./src/app/store-sample/store-sample.page.ts ***!
  \***************************************************/
/*! exports provided: StoreSamplePage */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "StoreSamplePage", function() { return StoreSamplePage; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ "./node_modules/@angular/core/fesm5/core.js");
/* harmony import */ var _providers_user_data__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../providers/user-data */ "./src/providers/user-data.ts");
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/router */ "./node_modules/@angular/router/fesm5/router.js");
/* harmony import */ var _ionic_storage__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @ionic/storage */ "./node_modules/@ionic/storage/fesm5/ionic-storage.js");
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @ionic/angular */ "./node_modules/@ionic/angular/dist/fesm5.js");
/* harmony import */ var _providers_common_service__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../providers/common.service */ "./src/providers/common.service.ts");







var StoreSamplePage = /** @class */ (function () {
    function StoreSamplePage(userData, commonService, router, storage) {
        this.userData = userData;
        this.commonService = commonService;
        this.router = router;
        this.storage = storage;
        this.storeSampleList = [{
                id: '',
                shelves: "",
                code: "",
                active: '',
                lend: '',
                updatetime: "",
                count: '',
                statusName: '',
                lendName: ''
            }];
        this.current = 1;
        this.size = 10;
    }
    StoreSamplePage.prototype.ngOnInit = function () {
    };
    StoreSamplePage.prototype.ionViewDidEnter = function () {
        this.getList();
    };
    StoreSamplePage.prototype.showFullScreenImage = function (form) {
        this.commonService.fullScreenImg(form);
    };
    StoreSamplePage.prototype.doRefresh = function (event) {
        this.getList();
        event.target.complete(); //告诉ion-refresher  更新数据
    };
    StoreSamplePage.prototype.loadData = function (event) {
        return tslib__WEBPACK_IMPORTED_MODULE_0__["__awaiter"](this, void 0, void 0, function () {
            return tslib__WEBPACK_IMPORTED_MODULE_0__["__generator"](this, function (_a) {
                switch (_a.label) {
                    case 0:
                        this.size += 10;
                        return [4 /*yield*/, this.getList()];
                    case 1:
                        _a.sent();
                        event.target.complete();
                        if (this.storeSampleList.length < this.size) {
                            event.target.disabled = true;
                        }
                        return [2 /*return*/];
                }
            });
        });
    };
    StoreSamplePage.prototype.getList = function () {
        return tslib__WEBPACK_IMPORTED_MODULE_0__["__awaiter"](this, void 0, void 0, function () {
            var data, _i, data_1, i;
            return tslib__WEBPACK_IMPORTED_MODULE_0__["__generator"](this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, this.userData.getStoreSampleList(this.current, this.size)];
                    case 1:
                        data = _a.sent();
                        for (_i = 0, data_1 = data; _i < data_1.length; _i++) {
                            i = data_1[_i];
                            i.statusName = i.active ? '正常' : '已销毁';
                            i.lendName = i.lend ? '已借出' : '未借出';
                            if (i["pictures"] && i["pictures"].length !== 0) {
                                i["imgsrc"] = i["pictures"][0].smallPicture;
                            }
                        }
                        this.storeSampleList = data;
                        return [2 /*return*/];
                }
            });
        });
    };
    StoreSamplePage.prototype.lend = function (storeSample) {
        return tslib__WEBPACK_IMPORTED_MODULE_0__["__awaiter"](this, void 0, void 0, function () {
            return tslib__WEBPACK_IMPORTED_MODULE_0__["__generator"](this, function (_a) {
                switch (_a.label) {
                    case 0:
                        storeSample.lend = true;
                        return [4 /*yield*/, this.userData.changeShelf(storeSample)];
                    case 1:
                        _a.sent();
                        this.getList();
                        return [2 /*return*/];
                }
            });
        });
    };
    // getDetail(storeSample) {
    //   this.storage.set('shelf', JSON.stringify(storeSample)).then(() => {
    //     this.router.navigateByUrl('/store-sample-binding')
    //   })
    // }
    StoreSamplePage.prototype.destroy = function (storeSample) {
        return tslib__WEBPACK_IMPORTED_MODULE_0__["__awaiter"](this, void 0, void 0, function () {
            return tslib__WEBPACK_IMPORTED_MODULE_0__["__generator"](this, function (_a) {
                switch (_a.label) {
                    case 0:
                        storeSample.active = false;
                        return [4 /*yield*/, this.userData.changeShelf(storeSample)];
                    case 1:
                        _a.sent();
                        this.getList();
                        return [2 /*return*/];
                }
            });
        });
    };
    tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"]([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ViewChild"])(_ionic_angular__WEBPACK_IMPORTED_MODULE_5__["IonInfiniteScroll"]),
        tslib__WEBPACK_IMPORTED_MODULE_0__["__metadata"]("design:type", _ionic_angular__WEBPACK_IMPORTED_MODULE_5__["IonInfiniteScroll"])
    ], StoreSamplePage.prototype, "infiniteScroll", void 0);
    StoreSamplePage = tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"]([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["Component"])({
            selector: 'app-store-sample',
            template: __webpack_require__(/*! ./store-sample.page.html */ "./src/app/store-sample/store-sample.page.html"),
            styles: [__webpack_require__(/*! ./store-sample.page.scss */ "./src/app/store-sample/store-sample.page.scss")]
        }),
        tslib__WEBPACK_IMPORTED_MODULE_0__["__metadata"]("design:paramtypes", [_providers_user_data__WEBPACK_IMPORTED_MODULE_2__["UserData"], _providers_common_service__WEBPACK_IMPORTED_MODULE_6__["commonService"], _angular_router__WEBPACK_IMPORTED_MODULE_3__["Router"], _ionic_storage__WEBPACK_IMPORTED_MODULE_4__["Storage"]])
    ], StoreSamplePage);
    return StoreSamplePage;
}());



/***/ })

}]);
//# sourceMappingURL=store-sample-store-sample-module.js.map