/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.client.android.encode;

import android.telephony.PhoneNumberUtils;
import com.google.zxing.client.android.encode.Formatter;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

final class VCardTelDisplayFormatter
implements Formatter {
    private final List<Map<String, Set<String>>> metadataForIndex;

    VCardTelDisplayFormatter() {
        this(null);
    }

    VCardTelDisplayFormatter(List<Map<String, Set<String>>> metadataForIndex) {
        this.metadataForIndex = metadataForIndex;
    }

    @Override
    public CharSequence format(CharSequence value, int index) {
        value = PhoneNumberUtils.formatNumber((String)value.toString());
        Map<String, Set<String>> metadata = this.metadataForIndex == null || this.metadataForIndex.size() <= index ? null : this.metadataForIndex.get(index);
        value = VCardTelDisplayFormatter.formatMetadata(value, metadata);
        return value;
    }

    private static CharSequence formatMetadata(CharSequence value, Map<String, Set<String>> metadata) {
        if (metadata == null || metadata.isEmpty()) {
            return value;
        }
        StringBuilder withMetadata = new StringBuilder();
        for (Map.Entry<String, Set<String>> metadatum : metadata.entrySet()) {
            Set<String> values = metadatum.getValue();
            if (values == null || values.isEmpty()) continue;
            Iterator<String> valuesIt = values.iterator();
            withMetadata.append(valuesIt.next());
            while (valuesIt.hasNext()) {
                withMetadata.append(',').append(valuesIt.next());
            }
        }
        if (withMetadata.length() > 0) {
            withMetadata.append(' ');
        }
        withMetadata.append(value);
        return withMetadata;
    }
}

