/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.client.android.history;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.ListActivity;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.Log;
import android.view.ContextMenu;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.ListAdapter;
import android.widget.ListView;
import barcodescanner.xservices.nl.barcodescanner.R;
import com.google.zxing.client.android.CaptureActivity;
import com.google.zxing.client.android.history.HistoryItem;
import com.google.zxing.client.android.history.HistoryItemAdapter;
import com.google.zxing.client.android.history.HistoryManager;
import java.util.List;

public final class HistoryActivity
extends ListActivity {
    private static final String TAG = HistoryActivity.class.getSimpleName();
    private HistoryManager historyManager;
    private ArrayAdapter<HistoryItem> adapter;
    private CharSequence originalTitle;

    protected void onCreate(Bundle icicle) {
        super.onCreate(icicle);
        this.historyManager = new HistoryManager((Activity)this);
        this.adapter = new HistoryItemAdapter((Context)this);
        this.setListAdapter((ListAdapter)this.adapter);
        ListView listview = this.getListView();
        this.registerForContextMenu((View)listview);
        this.originalTitle = this.getTitle();
    }

    protected void onResume() {
        super.onResume();
        this.reloadHistoryItems();
    }

    private void reloadHistoryItems() {
        List<HistoryItem> items = this.historyManager.buildHistoryItems();
        this.adapter.clear();
        for (HistoryItem item : items) {
            this.adapter.add((Object)item);
        }
        this.setTitle(this.originalTitle + " (" + this.adapter.getCount() + ')');
        if (this.adapter.isEmpty()) {
            this.adapter.add((Object)new HistoryItem(null, null, null));
        }
    }

    protected void onListItemClick(ListView l, View v, int position, long id2) {
        if (((HistoryItem)this.adapter.getItem(position)).getResult() != null) {
            Intent intent = new Intent((Context)this, CaptureActivity.class);
            intent.putExtra("ITEM_NUMBER", position);
            this.setResult(-1, intent);
            this.finish();
        }
    }

    public void onCreateContextMenu(ContextMenu menu2, View v, ContextMenu.ContextMenuInfo menuInfo) {
        int position = ((AdapterView.AdapterContextMenuInfo)menuInfo).position;
        if (position >= this.adapter.getCount() || ((HistoryItem)this.adapter.getItem(position)).getResult() != null) {
            menu2.add(0, position, position, R.string.history_clear_one_history_text);
        }
    }

    public boolean onContextItemSelected(MenuItem item) {
        int position = item.getItemId();
        this.historyManager.deleteHistoryItem(position);
        this.reloadHistoryItems();
        return true;
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        if (this.historyManager.hasHistoryItems()) {
            MenuInflater menuInflater = this.getMenuInflater();
            menuInflater.inflate(R.menu.history, menu2);
        }
        return super.onCreateOptionsMenu(menu2);
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        int i = item.getItemId();
        if (i == R.id.menu_history_send) {
            CharSequence history = this.historyManager.buildHistory();
            Uri historyFile = HistoryManager.saveHistory(history.toString());
            if (historyFile == null) {
                AlertDialog.Builder builder = new AlertDialog.Builder((Context)this);
                builder.setMessage(R.string.msg_unmount_usb);
                builder.setPositiveButton(R.string.button_ok, null);
                builder.show();
            } else {
                Intent intent = new Intent("android.intent.action.SEND", Uri.parse((String)"mailto:"));
                intent.addFlags(524288);
                String subject = this.getResources().getString(R.string.history_email_title);
                intent.putExtra("android.intent.extra.SUBJECT", subject);
                intent.putExtra("android.intent.extra.TEXT", subject);
                intent.putExtra("android.intent.extra.STREAM", (Parcelable)historyFile);
                intent.setType("text/csv");
                try {
                    this.startActivity(intent);
                }
                catch (ActivityNotFoundException anfe) {
                    Log.w((String)TAG, (String)anfe.toString());
                }
            }
        } else if (i == R.id.menu_history_clear_text) {
            AlertDialog.Builder builder = new AlertDialog.Builder((Context)this);
            builder.setMessage(R.string.msg_sure);
            builder.setCancelable(true);
            builder.setPositiveButton(R.string.button_ok, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int i2) {
                    HistoryActivity.this.historyManager.clearHistory();
                    dialog.dismiss();
                    HistoryActivity.this.finish();
                }
            });
            builder.setNegativeButton(R.string.button_cancel, null);
            builder.show();
        } else {
            return super.onOptionsItemSelected(item);
        }
        return true;
    }
}

