/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.client.android.history;

import android.app.Activity;
import android.content.ContentValues;
import android.content.Context;
import android.content.SharedPreferences;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.net.Uri;
import android.os.Environment;
import android.preference.PreferenceManager;
import android.util.Log;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.Result;
import com.google.zxing.client.android.history.DBHelper;
import com.google.zxing.client.android.history.HistoryItem;
import com.google.zxing.client.android.result.ResultHandler;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public final class HistoryManager {
    private static final String TAG = HistoryManager.class.getSimpleName();
    private static final int MAX_ITEMS = 2000;
    private static final String[] COLUMNS = new String[]{"text", "display", "format", "timestamp", "details"};
    private static final String[] COUNT_COLUMN = new String[]{"COUNT(1)"};
    private static final String[] ID_COL_PROJECTION = new String[]{"id"};
    private static final String[] ID_DETAIL_COL_PROJECTION = new String[]{"id", "details"};
    private final Activity activity;
    private final boolean enableHistory;

    public HistoryManager(Activity activity) {
        this.activity = activity;
        SharedPreferences prefs = PreferenceManager.getDefaultSharedPreferences((Context)activity);
        this.enableHistory = prefs.getBoolean("preferences_history", true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasHistoryItems() {
        boolean bl;
        DBHelper helper = new DBHelper((Context)this.activity);
        SQLiteDatabase db = null;
        Cursor cursor = null;
        try {
            db = helper.getReadableDatabase();
            cursor = db.query("history", COUNT_COLUMN, null, null, null, null, null);
            cursor.moveToFirst();
            bl = cursor.getInt(0) > 0;
        }
        catch (Throwable throwable) {
            HistoryManager.close(cursor, db);
            throw throwable;
        }
        HistoryManager.close(cursor, db);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<HistoryItem> buildHistoryItems() {
        DBHelper helper = new DBHelper((Context)this.activity);
        ArrayList<HistoryItem> items = new ArrayList<HistoryItem>();
        SQLiteDatabase db = null;
        Cursor cursor = null;
        try {
            db = helper.getReadableDatabase();
            cursor = db.query("history", COLUMNS, null, null, null, null, "timestamp DESC");
            while (cursor.moveToNext()) {
                String text = cursor.getString(0);
                String display = cursor.getString(1);
                String format = cursor.getString(2);
                long timestamp = cursor.getLong(3);
                String details = cursor.getString(4);
                Result result = new Result(text, null, null, BarcodeFormat.valueOf(format), timestamp);
                items.add(new HistoryItem(result, display, details));
            }
        }
        catch (Throwable throwable) {
            HistoryManager.close(cursor, db);
            throw throwable;
        }
        HistoryManager.close(cursor, db);
        return items;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HistoryItem buildHistoryItem(int number) {
        HistoryItem historyItem;
        DBHelper helper = new DBHelper((Context)this.activity);
        SQLiteDatabase db = null;
        Cursor cursor = null;
        try {
            db = helper.getReadableDatabase();
            cursor = db.query("history", COLUMNS, null, null, null, null, "timestamp DESC");
            cursor.move(number + 1);
            String text = cursor.getString(0);
            String display = cursor.getString(1);
            String format = cursor.getString(2);
            long timestamp = cursor.getLong(3);
            String details = cursor.getString(4);
            Result result = new Result(text, null, null, BarcodeFormat.valueOf(format), timestamp);
            historyItem = new HistoryItem(result, display, details);
        }
        catch (Throwable throwable) {
            HistoryManager.close(cursor, db);
            throw throwable;
        }
        HistoryManager.close(cursor, db);
        return historyItem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteHistoryItem(int number) {
        DBHelper helper = new DBHelper((Context)this.activity);
        SQLiteDatabase db = null;
        Cursor cursor = null;
        try {
            db = helper.getWritableDatabase();
            cursor = db.query("history", ID_COL_PROJECTION, null, null, null, null, "timestamp DESC");
            cursor.move(number + 1);
            db.delete("history", "id=" + cursor.getString(0), null);
        }
        catch (Throwable throwable) {
            HistoryManager.close(cursor, db);
            throw throwable;
        }
        HistoryManager.close(cursor, db);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHistoryItem(Result result, ResultHandler handler) {
        if (!this.activity.getIntent().getBooleanExtra("SAVE_HISTORY", true) || handler.areContentsSecure() || !this.enableHistory) {
            return;
        }
        SharedPreferences prefs = PreferenceManager.getDefaultSharedPreferences((Context)this.activity);
        if (!prefs.getBoolean("preferences_remember_duplicates", false)) {
            this.deletePrevious(result.getText());
        }
        ContentValues values = new ContentValues();
        values.put("text", result.getText());
        values.put("format", result.getBarcodeFormat().toString());
        values.put("display", handler.getDisplayContents().toString());
        values.put("timestamp", Long.valueOf(System.currentTimeMillis()));
        DBHelper helper = new DBHelper((Context)this.activity);
        SQLiteDatabase db = null;
        try {
            db = helper.getWritableDatabase();
            db.insert("history", "timestamp", values);
        }
        finally {
            HistoryManager.close(null, db);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHistoryItemDetails(String itemID, String itemDetails) {
        DBHelper helper = new DBHelper((Context)this.activity);
        SQLiteDatabase db = null;
        Cursor cursor = null;
        try {
            Object newDetails;
            db = helper.getWritableDatabase();
            cursor = db.query("history", ID_DETAIL_COL_PROJECTION, "text=?", new String[]{itemID}, null, null, "timestamp DESC", "1");
            String oldID = null;
            String oldDetails = null;
            if (cursor.moveToNext()) {
                oldID = cursor.getString(0);
                oldDetails = cursor.getString(1);
            }
            if (oldID != null && (newDetails = oldDetails == null ? itemDetails : (oldDetails.contains(itemDetails) ? null : oldDetails + " : " + itemDetails)) != null) {
                ContentValues values = new ContentValues();
                values.put("details", (String)newDetails);
                db.update("history", values, "id=?", new String[]{oldID});
            }
        }
        catch (Throwable throwable) {
            HistoryManager.close(cursor, db);
            throw throwable;
        }
        HistoryManager.close(cursor, db);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deletePrevious(String text) {
        DBHelper helper = new DBHelper((Context)this.activity);
        SQLiteDatabase db = null;
        try {
            db = helper.getWritableDatabase();
            db.delete("history", "text=?", new String[]{text});
        }
        finally {
            HistoryManager.close(null, db);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trimHistory() {
        DBHelper helper = new DBHelper((Context)this.activity);
        SQLiteDatabase db = null;
        Cursor cursor = null;
        try {
            db = helper.getWritableDatabase();
            cursor = db.query("history", ID_COL_PROJECTION, null, null, null, null, "timestamp DESC");
            cursor.move(2000);
            while (cursor.moveToNext()) {
                String id2 = cursor.getString(0);
                Log.i((String)TAG, (String)("Deleting scan history ID " + id2));
                db.delete("history", "id=" + id2, null);
            }
            HistoryManager.close(cursor, db);
        }
        catch (SQLiteException sqle) {
            Log.w((String)TAG, (Throwable)sqle);
        }
        finally {
            HistoryManager.close(cursor, db);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CharSequence buildHistory() {
        StringBuilder stringBuilder;
        DBHelper helper = new DBHelper((Context)this.activity);
        SQLiteDatabase db = null;
        Cursor cursor = null;
        try {
            db = helper.getWritableDatabase();
            cursor = db.query("history", COLUMNS, null, null, null, null, "timestamp DESC");
            DateFormat format = DateFormat.getDateTimeInstance(2, 2);
            StringBuilder historyText = new StringBuilder(1000);
            while (cursor.moveToNext()) {
                historyText.append('\"').append(HistoryManager.massageHistoryField(cursor.getString(0))).append("\",");
                historyText.append('\"').append(HistoryManager.massageHistoryField(cursor.getString(1))).append("\",");
                historyText.append('\"').append(HistoryManager.massageHistoryField(cursor.getString(2))).append("\",");
                historyText.append('\"').append(HistoryManager.massageHistoryField(cursor.getString(3))).append("\",");
                long timestamp = cursor.getLong(3);
                historyText.append('\"').append(HistoryManager.massageHistoryField(format.format(new Date(timestamp)))).append("\",");
                historyText.append('\"').append(HistoryManager.massageHistoryField(cursor.getString(4))).append("\"\r\n");
            }
            stringBuilder = historyText;
        }
        catch (Throwable throwable) {
            HistoryManager.close(cursor, db);
            throw throwable;
        }
        HistoryManager.close(cursor, db);
        return stringBuilder;
    }

    void clearHistory() {
        DBHelper helper = new DBHelper((Context)this.activity);
        SQLiteDatabase db = null;
        try {
            db = helper.getWritableDatabase();
            db.delete("history", null, null);
        }
        finally {
            HistoryManager.close(null, db);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Uri saveHistory(String history) {
        File bsRoot = new File(Environment.getExternalStorageDirectory(), "BarcodeScanner");
        File historyRoot = new File(bsRoot, "History");
        if (!historyRoot.exists() && !historyRoot.mkdirs()) {
            Log.w((String)TAG, (String)("Couldn't make dir " + historyRoot));
            return null;
        }
        File historyFile = new File(historyRoot, "history-" + System.currentTimeMillis() + ".csv");
        OutputStreamWriter out = null;
        try {
            out = new OutputStreamWriter((OutputStream)new FileOutputStream(historyFile), Charset.forName("UTF-8"));
            out.write(history);
            Uri uri = Uri.parse((String)("file://" + historyFile.getAbsolutePath()));
            return uri;
        }
        catch (IOException ioe) {
            Log.w((String)TAG, (String)("Couldn't access file " + historyFile + " due to " + ioe));
            Uri uri = null;
            return uri;
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static String massageHistoryField(String value) {
        return value == null ? "" : value.replace("\"", "\"\"");
    }

    private static void close(Cursor cursor, SQLiteDatabase database) {
        if (cursor != null) {
            cursor.close();
        }
        if (database != null) {
            database.close();
        }
    }
}

