/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.client.android.result;

import com.google.zxing.Result;
import com.google.zxing.client.android.CaptureActivity;
import com.google.zxing.client.android.result.AddressBookResultHandler;
import com.google.zxing.client.android.result.CalendarResultHandler;
import com.google.zxing.client.android.result.EmailAddressResultHandler;
import com.google.zxing.client.android.result.GeoResultHandler;
import com.google.zxing.client.android.result.ISBNResultHandler;
import com.google.zxing.client.android.result.ProductResultHandler;
import com.google.zxing.client.android.result.ResultHandler;
import com.google.zxing.client.android.result.SMSResultHandler;
import com.google.zxing.client.android.result.TelResultHandler;
import com.google.zxing.client.android.result.TextResultHandler;
import com.google.zxing.client.android.result.URIResultHandler;
import com.google.zxing.client.android.result.WifiResultHandler;
import com.google.zxing.client.result.ParsedResult;
import com.google.zxing.client.result.ResultParser;

public final class ResultHandlerFactory {
    private ResultHandlerFactory() {
    }

    public static ResultHandler makeResultHandler(CaptureActivity activity, Result rawResult) {
        ParsedResult result = ResultHandlerFactory.parseResult(rawResult);
        switch (result.getType()) {
            case ADDRESSBOOK: {
                return new AddressBookResultHandler(activity, result);
            }
            case EMAIL_ADDRESS: {
                return new EmailAddressResultHandler(activity, result);
            }
            case PRODUCT: {
                return new ProductResultHandler(activity, result, rawResult);
            }
            case URI: {
                return new URIResultHandler(activity, result);
            }
            case WIFI: {
                return new WifiResultHandler(activity, result);
            }
            case GEO: {
                return new GeoResultHandler(activity, result);
            }
            case TEL: {
                return new TelResultHandler(activity, result);
            }
            case SMS: {
                return new SMSResultHandler(activity, result);
            }
            case CALENDAR: {
                return new CalendarResultHandler(activity, result);
            }
            case ISBN: {
                return new ISBNResultHandler(activity, result, rawResult);
            }
        }
        return new TextResultHandler(activity, result, rawResult);
    }

    private static ParsedResult parseResult(Result rawResult) {
        return ResultParser.parseResult(rawResult);
    }
}

