/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.client.android;

import android.graphics.Bitmap;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.Log;
import barcodescanner.xservices.nl.barcodescanner.R;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.DecodeHintType;
import com.google.zxing.MultiFormatReader;
import com.google.zxing.PlanarYUVLuminanceSource;
import com.google.zxing.ReaderException;
import com.google.zxing.Result;
import com.google.zxing.client.android.CaptureActivity;
import com.google.zxing.common.HybridBinarizer;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Map;

final class DecodeHandler
extends Handler {
    private static final String TAG = DecodeHandler.class.getSimpleName();
    private final CaptureActivity activity;
    private final MultiFormatReader multiFormatReader = new MultiFormatReader();
    private boolean running = true;
    private int frameCount;

    DecodeHandler(CaptureActivity activity, Map<DecodeHintType, Object> hints) {
        this.multiFormatReader.setHints(hints);
        this.activity = activity;
    }

    public void handleMessage(Message message) {
        if (!this.running) {
            return;
        }
        if (message.what == R.id.decode) {
            this.decode((byte[])message.obj, message.arg1, message.arg2);
        } else if (message.what == R.id.quit) {
            this.running = false;
            Looper.myLooper().quit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decode(byte[] data, int width, int height) {
        long start = System.currentTimeMillis();
        Result rawResult = null;
        if (this.frameCount == 3) {
            this.frameCount = 0;
            int[] argb = new int[width * height];
            DecodeHandler.YUV_NV21_TO_RGB(argb, data, width, height);
            for (int i = 0; i < argb.length; ++i) {
                argb[i] = 0xFFFFFF - argb[i];
            }
            this.encodeYUV420SP(data, argb, width, height);
        }
        ++this.frameCount;
        PlanarYUVLuminanceSource source = this.activity.getCameraManager().buildLuminanceSource(data, width, height);
        if (source != null) {
            BinaryBitmap bitmap = new BinaryBitmap(new HybridBinarizer(source));
            try {
                rawResult = this.multiFormatReader.decodeWithState(bitmap);
            }
            catch (ReaderException readerException) {
            }
            finally {
                this.multiFormatReader.reset();
            }
        }
        Handler handler = this.activity.getHandler();
        if (rawResult != null) {
            long end = System.currentTimeMillis();
            Log.d((String)TAG, (String)("Found barcode in " + (end - start) + " ms"));
            if (handler != null) {
                Message message = Message.obtain((Handler)handler, (int)R.id.decode_succeeded, (Object)rawResult);
                Bundle bundle = new Bundle();
                DecodeHandler.bundleThumbnail(source, bundle);
                message.setData(bundle);
                message.sendToTarget();
            }
        } else if (handler != null) {
            Message message = Message.obtain((Handler)handler, (int)R.id.decode_failed);
            message.sendToTarget();
        }
    }

    private static void bundleThumbnail(PlanarYUVLuminanceSource source, Bundle bundle) {
        int[] pixels = source.renderThumbnail();
        int width = source.getThumbnailWidth();
        int height = source.getThumbnailHeight();
        Bitmap bitmap = Bitmap.createBitmap((int[])pixels, (int)0, (int)width, (int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        bitmap.compress(Bitmap.CompressFormat.JPEG, 50, (OutputStream)out);
        bundle.putByteArray("barcode_bitmap", out.toByteArray());
        bundle.putFloat("barcode_scaled_factor", (float)width / (float)source.getWidth());
    }

    private static void YUV_NV21_TO_RGB(int[] argb, byte[] yuv, int width, int height) {
        int frameSize = width * height;
        boolean ii = false;
        boolean ij = false;
        boolean di = true;
        boolean dj = true;
        int a = 0;
        int i = 0;
        int ci = 0;
        while (i < height) {
            int j = 0;
            int cj = 0;
            while (j < width) {
                int y = 0xFF & yuv[ci * width + cj];
                int v = 0xFF & yuv[frameSize + (ci >> 1) * width + (cj & 0xFFFFFFFE) + 0];
                int u = 0xFF & yuv[frameSize + (ci >> 1) * width + (cj & 0xFFFFFFFE) + 1];
                y = y < 16 ? 16 : y;
                int a0 = 1192 * (y - 16);
                int a1 = 1634 * (v - 128);
                int a2 = 832 * (v - 128);
                int a3 = 400 * (u - 128);
                int a4 = 2066 * (u - 128);
                int r = a0 + a1 >> 10;
                int g = a0 - a2 - a3 >> 10;
                int b = a0 + a4 >> 10;
                int n = r < 0 ? 0 : (r = r > 255 ? 255 : r);
                int n2 = g < 0 ? 0 : (g = g > 255 ? 255 : g);
                b = b < 0 ? 0 : (b > 255 ? 255 : b);
                argb[a++] = 0 | r << 16 | g << 8 | b;
                ++j;
                ++cj;
            }
            ++i;
            ++ci;
        }
    }

    void encodeYUV420SP(byte[] yuv420sp, int[] argb, int width, int height) {
        int frameSize = width * height;
        int yIndex = 0;
        int uIndex = frameSize;
        int vIndex = frameSize + (yuv420sp.length - frameSize) / 2;
        System.out.println(yuv420sp.length + " " + frameSize);
        int index = 0;
        for (int j = 0; j < height; ++j) {
            for (int i = 0; i < width; ++i) {
                int a = (argb[index] & 0xFF000000) >> 24;
                int R2 = (argb[index] & 0xFF0000) >> 16;
                int G = (argb[index] & 0xFF00) >> 8;
                int B = (argb[index] & 0xFF) >> 0;
                int Y = (66 * R2 + 129 * G + 25 * B + 128 >> 8) + 16;
                int U = (-38 * R2 - 74 * G + 112 * B + 128 >> 8) + 128;
                int V = (112 * R2 - 94 * G - 18 * B + 128 >> 8) + 128;
                yuv420sp[yIndex++] = (byte)(Y < 0 ? 0 : (Y > 255 ? 255 : Y));
                if (j % 2 == 0 && index % 2 == 0) {
                    yuv420sp[uIndex++] = (byte)(U < 0 ? 0 : (U > 255 ? 255 : U));
                    yuv420sp[vIndex++] = (byte)(V < 0 ? 0 : (V > 255 ? 255 : V));
                }
                ++index;
            }
        }
    }
}

