/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.client.android.encode;

import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Bundle;
import android.telephony.PhoneNumberUtils;
import android.util.Log;
import barcodescanner.xservices.nl.barcodescanner.R;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.Result;
import com.google.zxing.WriterException;
import com.google.zxing.client.android.Contents;
import com.google.zxing.client.android.encode.ContactEncoder;
import com.google.zxing.client.android.encode.MECARDContactEncoder;
import com.google.zxing.client.android.encode.VCardContactEncoder;
import com.google.zxing.client.result.AddressBookParsedResult;
import com.google.zxing.client.result.ParsedResult;
import com.google.zxing.client.result.ResultParser;
import com.google.zxing.common.BitMatrix;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;

final class QRCodeEncoder {
    private static final String TAG = QRCodeEncoder.class.getSimpleName();
    private static final int WHITE = -1;
    private static final int BLACK = -16777216;
    private final Context activity;
    private String contents;
    private String displayContents;
    private String title;
    private BarcodeFormat format;
    private final int dimension;
    private final boolean useVCard;

    QRCodeEncoder(Context activity, Intent intent, int dimension, boolean useVCard) throws WriterException {
        this.activity = activity;
        this.dimension = dimension;
        this.useVCard = useVCard;
        String action = intent.getAction();
        if ("com.google.zxing.client.android.ENCODE".equals(action)) {
            this.encodeContentsFromZXingIntent(intent);
        } else if ("android.intent.action.SEND".equals(action)) {
            this.encodeContentsFromShareIntent(intent);
        }
    }

    String getContents() {
        return this.contents;
    }

    String getDisplayContents() {
        return this.displayContents;
    }

    String getTitle() {
        return this.title;
    }

    boolean isUseVCard() {
        return this.useVCard;
    }

    private void encodeContentsFromZXingIntent(Intent intent) {
        String formatString = intent.getStringExtra("ENCODE_FORMAT");
        this.format = null;
        if (formatString != null) {
            try {
                this.format = BarcodeFormat.valueOf(formatString);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (this.format == null || this.format == BarcodeFormat.QR_CODE) {
            String type = intent.getStringExtra("ENCODE_TYPE");
            if (type != null && !type.isEmpty()) {
                this.format = BarcodeFormat.QR_CODE;
                this.encodeQRCodeContents(intent, type);
            }
        } else {
            String data = intent.getStringExtra("ENCODE_DATA");
            if (data != null && !data.isEmpty()) {
                this.contents = data;
                this.displayContents = data;
                this.title = this.activity.getString(R.string.contents_text);
            }
        }
    }

    private void encodeContentsFromShareIntent(Intent intent) throws WriterException {
        if (intent.hasExtra("android.intent.extra.STREAM")) {
            this.encodeFromStreamExtra(intent);
        } else {
            this.encodeFromTextExtras(intent);
        }
    }

    private void encodeFromTextExtras(Intent intent) throws WriterException {
        String theContents = ContactEncoder.trim(intent.getStringExtra("android.intent.extra.TEXT"));
        if (theContents == null && (theContents = ContactEncoder.trim(intent.getStringExtra("android.intent.extra.HTML_TEXT"))) == null && (theContents = ContactEncoder.trim(intent.getStringExtra("android.intent.extra.SUBJECT"))) == null) {
            String[] emails = intent.getStringArrayExtra("android.intent.extra.EMAIL");
            theContents = emails != null ? ContactEncoder.trim(emails[0]) : "?";
        }
        if (theContents == null || theContents.isEmpty()) {
            throw new WriterException("Empty EXTRA_TEXT");
        }
        this.contents = theContents;
        this.format = BarcodeFormat.QR_CODE;
        this.displayContents = intent.hasExtra("android.intent.extra.SUBJECT") ? intent.getStringExtra("android.intent.extra.SUBJECT") : (intent.hasExtra("android.intent.extra.TITLE") ? intent.getStringExtra("android.intent.extra.TITLE") : this.contents);
        this.title = this.activity.getString(R.string.contents_text);
    }

    private void encodeFromStreamExtra(Intent intent) throws WriterException {
        String vcardString;
        byte[] vcard;
        this.format = BarcodeFormat.QR_CODE;
        Bundle bundle = intent.getExtras();
        if (bundle == null) {
            throw new WriterException("No extras");
        }
        Uri uri = (Uri)bundle.getParcelable("android.intent.extra.STREAM");
        if (uri == null) {
            throw new WriterException("No EXTRA_STREAM");
        }
        InputStream stream = null;
        try {
            int bytesRead;
            stream = this.activity.getContentResolver().openInputStream(uri);
            if (stream == null) {
                throw new WriterException("Can't open stream for " + uri);
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buffer = new byte[2048];
            while ((bytesRead = stream.read(buffer)) > 0) {
                baos.write(buffer, 0, bytesRead);
            }
            vcard = baos.toByteArray();
            vcardString = new String(vcard, 0, vcard.length, "UTF-8");
        }
        catch (IOException ioe) {
            throw new WriterException(ioe);
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
        }
        Log.d((String)TAG, (String)"Encoding share intent content:");
        Log.d((String)TAG, (String)vcardString);
        Result result = new Result(vcardString, vcard, null, BarcodeFormat.QR_CODE);
        ParsedResult parsedResult = ResultParser.parseResult(result);
        if (!(parsedResult instanceof AddressBookParsedResult)) {
            throw new WriterException("Result was not an address");
        }
        this.encodeQRCodeContents((AddressBookParsedResult)parsedResult);
        if (this.contents == null || this.contents.isEmpty()) {
            throw new WriterException("No content to encode");
        }
    }

    private void encodeQRCodeContents(Intent intent, String type) {
        switch (type) {
            case "TEXT_TYPE": {
                String textData = intent.getStringExtra("ENCODE_DATA");
                if (textData == null || textData.isEmpty()) break;
                this.contents = textData;
                this.displayContents = textData;
                this.title = this.activity.getString(R.string.contents_text);
                break;
            }
            case "EMAIL_TYPE": {
                String emailData = ContactEncoder.trim(intent.getStringExtra("ENCODE_DATA"));
                if (emailData == null) break;
                this.contents = "mailto:" + emailData;
                this.displayContents = emailData;
                this.title = this.activity.getString(R.string.contents_email);
                break;
            }
            case "PHONE_TYPE": {
                String phoneData = ContactEncoder.trim(intent.getStringExtra("ENCODE_DATA"));
                if (phoneData == null) break;
                this.contents = "tel:" + phoneData;
                this.displayContents = PhoneNumberUtils.formatNumber((String)phoneData);
                this.title = this.activity.getString(R.string.contents_phone);
                break;
            }
            case "SMS_TYPE": {
                String smsData = ContactEncoder.trim(intent.getStringExtra("ENCODE_DATA"));
                if (smsData == null) break;
                this.contents = "sms:" + smsData;
                this.displayContents = PhoneNumberUtils.formatNumber((String)smsData);
                this.title = this.activity.getString(R.string.contents_sms);
                break;
            }
            case "CONTACT_TYPE": {
                Bundle contactBundle = intent.getBundleExtra("ENCODE_DATA");
                if (contactBundle == null) break;
                String name = contactBundle.getString("name");
                String organization = contactBundle.getString("company");
                String address = contactBundle.getString("postal");
                List<String> phones = QRCodeEncoder.getAllBundleValues(contactBundle, Contents.PHONE_KEYS);
                List<String> phoneTypes = QRCodeEncoder.getAllBundleValues(contactBundle, Contents.PHONE_TYPE_KEYS);
                List<String> emails = QRCodeEncoder.getAllBundleValues(contactBundle, Contents.EMAIL_KEYS);
                String url = contactBundle.getString("URL_KEY");
                List<String> urls = url == null ? null : Collections.singletonList(url);
                String note = contactBundle.getString("NOTE_KEY");
                ContactEncoder encoder = this.useVCard ? new VCardContactEncoder() : new MECARDContactEncoder();
                String[] encoded = encoder.encode(Collections.singletonList(name), organization, Collections.singletonList(address), phones, phoneTypes, emails, urls, note);
                if (encoded[1].isEmpty()) break;
                this.contents = encoded[0];
                this.displayContents = encoded[1];
                this.title = this.activity.getString(R.string.contents_contact);
                break;
            }
            case "LOCATION_TYPE": {
                Bundle locationBundle = intent.getBundleExtra("ENCODE_DATA");
                if (locationBundle == null) break;
                float latitude = locationBundle.getFloat("LAT", Float.MAX_VALUE);
                float longitude = locationBundle.getFloat("LONG", Float.MAX_VALUE);
                if (latitude == Float.MAX_VALUE || longitude == Float.MAX_VALUE) break;
                this.contents = "geo:" + latitude + ',' + longitude;
                this.displayContents = latitude + "," + longitude;
                this.title = this.activity.getString(R.string.contents_location);
            }
        }
    }

    private static List<String> getAllBundleValues(Bundle bundle, String[] keys) {
        ArrayList<String> values = new ArrayList<String>(keys.length);
        for (String key : keys) {
            Object value = bundle.get(key);
            values.add(value == null ? null : value.toString());
        }
        return values;
    }

    private void encodeQRCodeContents(AddressBookParsedResult contact) {
        ContactEncoder encoder = this.useVCard ? new VCardContactEncoder() : new MECARDContactEncoder();
        String[] encoded = encoder.encode(QRCodeEncoder.toList(contact.getNames()), contact.getOrg(), QRCodeEncoder.toList(contact.getAddresses()), QRCodeEncoder.toList(contact.getPhoneNumbers()), null, QRCodeEncoder.toList(contact.getEmails()), QRCodeEncoder.toList(contact.getURLs()), null);
        if (!encoded[1].isEmpty()) {
            this.contents = encoded[0];
            this.displayContents = encoded[1];
            this.title = this.activity.getString(R.string.contents_contact);
        }
    }

    private static List<String> toList(String[] values) {
        return values == null ? null : Arrays.asList(values);
    }

    Bitmap encodeAsBitmap() throws WriterException {
        BitMatrix result;
        String contentsToEncode = this.contents;
        if (contentsToEncode == null) {
            return null;
        }
        EnumMap<EncodeHintType, String> hints = null;
        String encoding = QRCodeEncoder.guessAppropriateEncoding(contentsToEncode);
        if (encoding != null) {
            hints = new EnumMap<EncodeHintType, String>(EncodeHintType.class);
            hints.put(EncodeHintType.CHARACTER_SET, encoding);
        }
        try {
            result = new MultiFormatWriter().encode(contentsToEncode, this.format, this.dimension, this.dimension, hints);
        }
        catch (IllegalArgumentException iae) {
            return null;
        }
        int width = result.getWidth();
        int height = result.getHeight();
        int[] pixels = new int[width * height];
        for (int y = 0; y < height; ++y) {
            int offset = y * width;
            for (int x = 0; x < width; ++x) {
                pixels[offset + x] = result.get(x, y) ? -16777216 : -1;
            }
        }
        Bitmap bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        bitmap.setPixels(pixels, 0, width, 0, 0, width, height);
        return bitmap;
    }

    private static String guessAppropriateEncoding(CharSequence contents) {
        for (int i = 0; i < contents.length(); ++i) {
            if (contents.charAt(i) <= '\u00ff') continue;
            return "UTF-8";
        }
        return null;
    }
}

